unit ADOQuery_unit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, Grids, DBGrids, ADODB;

type
  TForm2 = class(TForm)
    DBGrid1: TDBGrid;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.dfm}

// BeginExample: ADOQuery
// Class: ADODB.TADOConnection
// Class: ADODB.TADOQuery
// Class: ADODB.TParameter
// Property: ADODB.TADOConnection.ConnectionString
// Property: DB.TCustomConnection.LoginPrompt
// Property: DB.TCustomConnection.Connected
// Property: ADODB.TCustomADODataSet.Parameters
// Property: ADODB.TCustomADODataSet.Connection
// Property: ADODB.TADOQuery.SQL
// Property: ADODB.TCustomADODataSet.Prepared

// BeginCode
{
This example demostrates the use of ADO for database conectivity.
Example assumes that a TDBGrid is placed on the form.
}
procedure TForm2.FormCreate(Sender: TObject);
const
  { Connection string }
  ConnString =
  'Provider=SQLOLEDB.1;Persist Security Info=False;' +
  'User ID=%s;Password=%s;Data Source=%s;Use Procedure for Prepare=1;' +
  'Auto Translate=True;Packet Size=4096;Use Encryption for Data=False;'+
  'Tag with column collation when possible=False';

  { SQL Query }
  SQLStr = 'SELECT * FROM customer WHERE customer_id = :AnId;';

  { User access }
  UserName = 'db_user_name';
  PassWord = 'db_pass_word';
  Server = 'my.db.server';

var
  ADOConn  : TADOConnection;
  ADOQuery : TADOQuery;
  DataSrc  : TDataSource;
  Param    : TParameter;

begin
  { Create an ADO connection }
  ADOConn := TADOConnection.Create(Self);
  { Setup the provider engine }

  { Setup the connection string }
  ADOConn.ConnectionString := Format(ConnString,
    [UserName, PassWord, Server]);

  { Disable login prompt }
  ADOConn.LoginPrompt := False;

  try
    ADOConn.Connected := True;
  except
    on e: EADOError do
    begin
      MessageDlg('Error while connecting', mtError,
                  [mbOK], 0);

      Exit;
    end;
  end;

  { Create the query }
  ADOQuery := TADOQuery.Create(Self);
  ADOQuery.Connection := ADOConn;
  ADOQuery.SQL.Add(SQLStr);

  { Update the parameter that was parsed from the SQL query: AnId }
  Param := ADOQuery.Parameters.ParamByName('AnId');
  Param.DataType := ftInteger;
  Param.Value := 1;

  { Set the query to Prepared - will improve performance }
  ADOQuery.Prepared := true;

  try
    ADOQuery.Active := True;
  except
    on e: EADOError do
    begin
      MessageDlg('Error while doing query', mtError,
                  [mbOK], 0);

      Exit;
    end;
  end;

  { Create the data source }
  DataSrc := TDataSource.Create(Self);
  DataSrc.DataSet := ADOQuery;
  DataSrc.Enabled := true;

  { Finally initilalize the grid }
  DBGrid1.DataSource := DataSrc;
end;

// EndCode
// EndExample: ADOQuery

end.
