unit ActivePage;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    ComboBox1: TComboBox;
    procedure ComboBox1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

  implementation

{$R *.dfm}

// BeginExample: ActivePage
// Property: ComCtrls.TPageControl.ActivePage
// Property: ComCtrls.TPageControl.PageCount
// Event: StdCtrls.TCustomCombo.OnChange
// Method: Classes.TStrings.AddObject

// BeginCode
{
This example requires a TPageControl already on the form.
Also, you must add pages to the TPageControl by right
clicking and selecting New Page.
The example code will allow the user to select the
ActivePage property through selection of a ComboBox item.
During the form create, the Combo Box control is loaded with
the names of each of the tabs, as well as the instance
pointers to the corresponding tab.  When the user selects
the Combo Box item, the associated TTabSheet object
contained in the Combo Box Objects array is used to set the
ActivePage property.  Select the Lines property of the 
TRichEdit to enter a string.  Select the string before 
justifying.
} 
procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
const
  colorarray : Array[0..4] of TColor = (
    clYellow, clGreen, clBlue, clLime, clFuchsia);
begin
  for i := 0 to PageControl1.PageCount - 1 do
    begin
    PageControl1.Pages[i].Brush.Color := colorarray[i];
    ComboBox1.Items.AddObject(PageControl1.Pages[i].Name,
      PageControl1.Pages[i]);
    end;
  ComboBox1.ItemIndex := 0;
  PageControl1.ActivePage := TTabSheet(ComboBox1.Items.Objects[ComboBox1.ItemIndex]);
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  if (Sender is TComboBox) then
    with (Sender as TComboBox) do
      PageControl1.ActivePage := TTabSheet(Items.Objects[ItemIndex]);
end;
// EndCode
// EndExample: ActivePage
end.
