{
ActivePage, PageCount, OnChange, AddObject example
This example requires a TPageControl already on the form. Also, you must add pages to the TPageControl by right clicking and selecting New Page.
The example code will allow the user to select the ActivePage property through selection of a ComboBox item.  During the form create, the Combo Box control is loaded with the names of each of the tabs, as well as the instance pointers to the corresponding tab.  When the user selects the Combo Box item, the associated TTabSheet object contained in the Combo Box Objects array is used to set the ActivePage property.
} 
procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  for i := 0 to PageControl1.PageCount - 1 do
    ComboBox1.Items.AddObject(PageControl1.Pages[i].Name,
      PageControl1.Pages[i]);
  ComboBox1.ItemIndex := 0;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  if (Sender is TComboBox) then
    with (Sender as TComboBox) do
      PageControl1.ActivePage := TTabSheet(Items.Objects[ItemIndex]);
end;
 
