{*******************************************************}
{                                                       }
{        Midas RemoteDataModule Pooler Demo             }
{                                                       }
{*******************************************************}

unit clntfrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBClient, Db, Grids, DBGrids, StdCtrls, MConnect, Variants, ComCtrls,
  ExtCtrls, DBCtrls, Mask;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    DBGrid1: TDBGrid;
    ClientDataSet1: TClientDataSet;
    RemoteServer1: TDCOMConnection;
    DataSource1: TDataSource;
//    CDSClone: TClientDataSet;
    Button2: TButton;
    Button3: TButton;
    Edit1: TEdit;
    Button4: TButton;
    Memo2: TMemo;
    DBNavigator2: TDBNavigator;
    DBEdit1: TDBEdit;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure ClientDataSet1BeforeGetRecords(Sender: TObject;
      var OwnerData: OleVariant);
    procedure Button2Click(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
    procedure CheckButtonActive(DataSet: TDataSet);
    procedure Button3Click(Sender: TObject);
    procedure RemoteServer1BeforeDisconnect(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure ClientDataSet1AfterEdit(DataSet: TDataSet);
    procedure ClientDataSet1BeforeEdit(DataSet: TDataSet);
    procedure ClientDataSet1AfterInsert(DataSet: TDataSet);
    procedure ClientDataSet1BeforeInsert(DataSet: TDataSet);
    procedure ClientDataSet1AfterPost(DataSet: TDataSet);
    procedure ClientDataSet1BeforePost(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{
Build the group project to generate server.exe and client.exe.
Run the server first by selecting server.exe and Run Without
Debugging, or execute server.exe outside of Delphi.  Then run
client.exe.  Click "Run SQL" first, then "GetNextPacket".
}

// BeginExample: AfterEdit
// Event: DB.TDataSet.AfterEdit
// Event: DB.TDataSet.BeforeEdit
// Method: DB.TDataSet.Edit
// Property: DB.TDataSet.RecNo

// BeginCode
{
This example adds an entry to a memo with a message
when an AfterEdit event occurs and when a BeforeEdit event
occurs.  Click on Run SQL to populate the DBGrid.  Then
select a cell to edit and click the Edit current cell
button, or just start editing the cell to invoke the
BeforeEdit and AfterEdit events.
} 
procedure TForm1.ClientDataSet1AfterEdit(DataSet: TDataSet);
begin
   Memo2.Lines.Add('After editing record' + IntToStr(DataSet.RecNo));
end;

procedure TForm1.ClientDataSet1BeforeEdit(DataSet: TDataSet);
begin
   Memo2.Lines.Add('Before editing record' + IntToStr(DataSet.RecNo));
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  ClientDataSet1.Edit;
end;
// EndCode
// EndExample: AfterEdit

// BeginExample: AfterInsert
// Event: DB.TDataSet.AfterInsert
// Event: DB.TDataSet.BeforeInsert

// BeginCode
{
This example updates a memo with a message when an
AfterInsert event or a BeforeInsert event occurs.
} 
procedure TForm1.ClientDataSet1AfterInsert(DataSet: TDataSet);
begin
   Memo2.Lines.Add('After inserting a record');
end;

procedure TForm1.ClientDataSet1BeforeInsert(DataSet: TDataSet);
begin
   Memo2.Lines.Add('Before inserting a record');
end;
// EndCode
// EndExample: AfterInsert

// BeginExample: BeforePost
// Event: DB.TDataSet.BeforePost
// Routine: SysUtils.Abort

// BeginCode
{
This example checks for a valid entry in a TDBEdit control
and calls the Abort procedure if the control is empty; Abort
cancels the post before it happens.
}
procedure TForm1.ClientDataSet1BeforePost(DataSet: TDataSet);
begin
  if DBEdit1.Text = '' then
    Abort;
  DataSet.Fields[2].AsString := DBEdit1.Text;
end;
// EndCode
// EndExample: BeforePost

// BeginExample: AfterOpen
// Event: DB.TDataSet.AfterOpen
// Event: DB.TDataSet.AfterClose

// BeginCode
{
This example adds an entry to a memo with a message when an
AfterOpen event or an AfterClose event occurs.  Populate the
ClientDataSet events with CheckButtonActive.
}
procedure TForm1.CheckButtonActive(DataSet: TDataSet);
begin
  if (Button1.Enabled) then
    Memo2.Lines.Add('Now that the dataset is open, record information is available.')
  else
    Memo2.Lines.Add('Now that the dataset is closed, record information is not available.');
  Button1.Enabled := not ClientDataSet1.Active;
  Button2.Enabled := ClientDataSet1.Active;
  Button3.Enabled := ClientDataSet1.Active;
end;
// EndCode
// EndExample: AfterOpen

// BeginExample: AfterPost
// Event: DB.TDataSet.AfterPost

// BeginCode
{
This example updates the forms status bar with a message
when an AfterPost event occurs.
} 
procedure TForm1.ClientDataSet1AfterPost(DataSet: TDataSet);
begin
   Memo2.Lines.Add('Before posting a record');
end;
// EndCode
// EndExample: AfterPost

procedure TForm1.ClientDataSet1BeforeGetRecords(Sender: TObject; var OwnerData: OleVariant);
var
  LastValue: OleVariant;
  CDSClone: TClientDataSet;
begin
  if ClientDataSet1.Active then
  begin
    CDSClone := TClientDataSet.Create(Form1);
    try
      CDSClone.CloneCursor(ClientDataSet1, True);
      { turn off FetchOnDemand so that the clone only fetches
        the last LOCAL record }
      CDSClone.FetchOnDemand := False;
      CDSClone.Last;
      LastValue := CDSClone.Fields[0].AsString;
      CDSClone.Close;
    finally
      CDSClone.Free;
    end;
  end else
    LastValue := NULL;
  OwnerData := VarArrayOf([Memo1.Lines.Text, LastValue]);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  ClientDataSet1.PacketRecords := StrToInt(Edit1.Text);
  ClientDataSet1.GetNextPacket;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  I: Integer;
begin
  if not RemoteServer1.Connected then
    RemoteServer1.Connected := True;
  ClientDataSet1.Close;
  with RemoteServer1 do
  begin
    for I := 0 to DataSetCount - 1 do
      DataSets[I].EnableControls;
  end;
  ClientDataSet1.Open;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  I: Integer;
begin
  ClientDataSet1.Close;
  RemoteServer1.Connected := False;
  with RemoteServer1 do
  begin
    for I := 0 to DataSetCount - 1 do
      DataSets[I].DisableControls;
  end;
end;

procedure TForm1.Memo1Change(Sender: TObject);
begin
  ClientDataSet1.Close;
end;

procedure TForm1.RemoteServer1BeforeDisconnect(Sender: TObject);
begin
  if (ClientDataSet1.ChangeCount > 0) then 
    ClientDataSet1.ApplyUpdates(-1);
end;

end.
