unit AppEvents;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  AppEvnts, ActnList, Menus, StdCtrls;

type
  TMainForm = class(TForm)
    ApplicationEvents: TApplicationEvents;
    ActionList: TActionList;
    MyAction: TAction;
    MainMenu: TMainMenu;
    MenuAction: TMenuItem;
    MenuException: TMenuItem;
    HintButton: TButton;
    lbOnMessage: TListBox;
    lblOnMessage: TLabel;
    lbOther: TListBox;
    lblOther: TLabel;
    lbIdle: TListBox;
    lblOnIdle: TLabel;
    lbActionUpdate: TListBox;
    lblOnActionUpdate: TLabel;
    function ApplicationEventsHelp(Command: Word; Data: Integer;
      var CallHelp: Boolean): Boolean;
    procedure ApplicationEventsActionExecute(Action: TBasicAction;
      var Handled: Boolean);
    procedure ApplicationEventsActionUpdate(Action: TBasicAction;
      var Handled: Boolean);
    procedure ApplicationEventsActivate(Sender: TObject);
    procedure ApplicationEventsDeactivate(Sender: TObject);
    procedure ApplicationEventsException(Sender: TObject; E: Exception);
    procedure ApplicationEventsHint(Sender: TObject);
    procedure ApplicationEventsIdle(Sender: TObject; var Done: Boolean);
    procedure ApplicationEventsMessage(var Msg: tagMSG;
      var Handled: Boolean);
    procedure ApplicationEventsMinimize(Sender: TObject);
    procedure ApplicationEventsRestore(Sender: TObject);
    procedure ApplicationEventsShortCut(var Msg: TWMKey;
      var Handled: Boolean);
    procedure ApplicationEventsShowHint(var HintStr: String;
      var CanShow: Boolean; var HintInfo: THintInfo);
    procedure MyActionExecute(Sender: TObject);
    procedure MenuExceptionClick(Sender: TObject);
    procedure ApplicationEventsSettingChange(Sender: TObject; Flag: Integer;
      const Section: string; var Result: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

// BeginExample: OnActionExecute
// Event: AppEvnts.TCustomApplicationEvents.OnActionExecute
// Event: Classes.TBasicAction.OnExecute

// BeginCode
{
This example requires a TApplicationEvents, a TActionList
and a TListBox in the form.  Select the TApplicationEvents,
double click on the OnActionExecute event and add the
following code to the handler.  Create an TAction named
MyAction in a TActionList.  The TActionList must have no
OnExecute event handler, and the TAction has an OnExecute
event handler called MyActionExecute.  Then set an object's
(such as a button) Action to MyAction.  The Handled
parameter of the event handler returns false by default. If
the handler handles the event, it should change Handled to
true, thereby preventing further attempts to handle the
action.
}
procedure TMainForm.ApplicationEventsActionExecute(Action: TBasicAction;
  var Handled: Boolean);
begin
  lbOther.Items.Add('Event OnActionExecute');
end;

procedure TMainForm.MyActionExecute(Sender: TObject);
begin
  ShowMessage('Action executed');
end;
// EndCode
// EndExample: OnActionExecute

// BeginExample: OnActionUpdate
// Event: AppEvnts.TCustomApplicationEvents.OnActionUpdate

// BeginCode
{
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnActionUpdate event and add the following code to
the handler.  Create other TApplicationEvents the same way.
When these events update this event is triggered.  The
Handled parameter of the event handler returns false by
default. If the handler handles the event, it should change
Handled to true, thereby preventing further attempts to
handle the action.
}
procedure TMainForm.ApplicationEventsActionUpdate(Action: TBasicAction;
  var Handled: Boolean);
begin
  lbActionUpdate.Items.Add('Event OnActionUpdate');
end;
// EndCode
// EndExample: OnActionUpdate

// BeginExample: OnActivate
// Event: AppEvnts.TCustomApplicationEvents.OnActivate
// Event: AppEvnts.TCustomApplicationEvents.OnDeactivate

// BeginCode
{
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnActivate event and add the following code
to the handler.  These events occur when the form gains
or loses focus.
}
procedure TMainForm.ApplicationEventsActivate(Sender: TObject);
begin
  lbOther.Items.Add('Event OnActivate');
end;

procedure TMainForm.ApplicationEventsDeactivate(Sender: TObject);
begin
  lbOther.Items.Add('Event OnDeactivate');
end;
// EndCode
// EndExample: OnActivate

// BeginExample: OnException
// Event: AppEvnts.TCustomApplicationEvents.OnException

// BeginCode
{
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnException event and add the following code
to the handler.  Trigger this event by calling the
Exception Create constructor.
}
procedure TMainForm.ApplicationEventsException(Sender: TObject;
  E: Exception);
begin
  lbOther.Items.Add('Event OnException: ' + E.Message);
end;

procedure TMainForm.MenuExceptionClick(Sender: TObject);
resourcestring
  sExceptionRaised = 'This is an exception';

begin
  raise Exception.Create(sExceptionRaised);
end;
// EndCode
// EndExample: OnException

// BeginExample: TAppEventsOnHint
// Event: AppEvnts.TCustomApplicationEvents.OnHint
// Event: AppEvnts.TCustomApplicationEvents.OnShowHint

// BeginCode
{
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnHint event and the OnShowHint event and add the
following code to the handlers.  OnHint is triggered when
the mouse passes over the control. OnShowHint is triggered
when the mouse passes over the control and the application
is about to display the hint window for a Help Hint
}
procedure TMainForm.ApplicationEventsHint(Sender: TObject);
begin
  lbOther.Items.Add('Event OnHint');
end;

procedure TMainForm.ApplicationEventsShowHint(var HintStr: String;
  var CanShow: Boolean; var HintInfo: THintInfo);
begin
  lbOther.Items.Add('Event OnShowHint');
end;
// EndCode
// EndExample: TAppEventsOnHint

// BeginExample: TAppEventsOnIdle
// Event: AppEvnts.TCustomApplicationEvents.OnIdle

// BeginCode
{
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnIdle event and add the following code to the
handler.  The OnIdle event handler is used to perform
special processing when an application is idle. An
application is idle when it is not processing code.
}
procedure TMainForm.ApplicationEventsIdle(Sender: TObject;
  var Done: Boolean);
begin
  lbIdle.Items.Add('Event OnIdle');
end;
// EndCode
// EndExample: TAppEventsOnIdle

// BeginExample: TAppEventsOnMessage
// Event: AppEvnts.TCustomApplicationEvents.OnMessage

// BeginCode
{
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnMessage event and add the following code to the
handler.  OnMessage is triggered when the application
receives a Windows message.
}
procedure TMainForm.ApplicationEventsMessage(var Msg: tagMSG;
  var Handled: Boolean);
begin
  lbOnMessage.Items.Add('X:=' + IntToStr(Msg.pt.x) + '|Y:=' + IntToStr(Msg.pt.y));
end;
// EndCode
// EndExample: TAppEventsOnMessage

// BeginExample: TAppEventsOnMinimize
// Event: AppEvnts.TCustomApplicationEvents.OnMinimize

// BeginCode
{
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnMinimize event and add the following code to the
handler.  OnMinimize is triggered when the form is
minimized.
}
procedure TMainForm.ApplicationEventsMinimize(Sender: TObject);
begin
  lbOther.Items.Add('Event OnMinimize');
end;
// EndCode
// EndExample: TAppEventsOnMinimize

// BeginExample: TAppEventsOnRestore
// Event: AppEvnts.TCustomApplicationEvents.OnRestore

// BeginCode
{
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnRestore event and add the following code to the
handler.  OnRestore is triggered when a minimized
application is restored.
}
procedure TMainForm.ApplicationEventsRestore(Sender: TObject);
begin
  lbOther.Items.Add('Event OnRestore');
end;
// EndCode
// EndExample: TAppEventsOnRestore

procedure TMainForm.ApplicationEventsSettingChange(Sender: TObject;
  Flag: Integer; const Section: string; var Result: Integer);
begin
  lbOther.Items.Add('Event OnSettingChange');
  lbOther.Items.BeginUpdate;
  try
    lbOther.Items.Add(Format('     Section  = %s', [Section]));
    lbOther.Items.Add(Format('     Flags  = %.8x', [Flag]));
    if AnsiSameStr(Section, 'intl') then
    with SysLocale do
    begin
      lbOther.Items.Add(Format('     DefaultLCID  = %.8x', [DefaultLCID]));
      lbOther.Items.Add(Format('     PriLangID  = %.8x', [PriLangID]));
      lbOther.Items.Add(Format('     SubLangID  = %.8x', [SubLangID]));
      lbOther.Items.Add(Format('     FarEast  = %s', [BoolToStr(FarEast, True)]));
      lbOther.Items.Add(Format('     MiddleEast  = %s', [BoolToStr(MiddleEast, True)]));
    end;
    lbOther.Items.Add('');
  finally
    lbOther.Items.EndUpdate;
  end;
end;

// BeginExample: OnShortCut
// Event: AppEvnts.TCustomApplicationEvents.OnShortCut

// BeginCode
{
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnShortCut event and add the following code to the
handler.  Trigger this event by pressing the CTRL key or
any function key.
}
procedure TMainForm.ApplicationEventsShortCut(var Msg: TWMKey;
  var Handled: Boolean);
begin
  lbOther.Items.Add('Event OnShortCut');
end;
// EndCode
// EndExample: OnShortCut

// BeginExample: OnHelp
// Event: AppEvnts.TCustomApplicationEvents.OnHelp

// BeginCode
{
This example requires a TApplicationEvents and a TListBox
in the form.  Select the TApplicationEvents, double click
on the OnHelp event and add the following code to the
handler.  Trigger this event by pressing the F1 key or
call the HelpContext method.  Set CallHelp to true if the
application should still invoke the help system after the
event.
}
function TMainForm.ApplicationEventsHelp(Command: Word; Data: Integer;
  var CallHelp: Boolean): Boolean;
begin
  lbOther.Items.Add('Event OnHelp');
  CallHelp := False;
end;
// EndCode
// EndExample: OnHelp

end.
