{
AssertErrorProc example
The following code is a self-contained unit that you can add to a project that logs failed assertions to the event log rather than raising an exception. If /Debug is passed to the application as a command-line parameter, all failed Assert calls cause a call to OutputDebugString, which sends a messages to the Event Log window if run from Delphi, or does nothing if run outside the IDE (OutputDebugString is a no-op if not run from within a debugger). A nice side benefit is that all the line numbers and unit names can be stripped from the EXE by turning off assertions and rebuilding the project.
Note:	This example was provided by Brian Long.
} 
unit AssertionHandlerU;
interface

implementation
uses SysUtils, Windows;

procedure AssertErrorHandler(const Message, Filename: string;  LineNumber: Integer; ErrorAddr: Pointer);
var
  S: String;
begin
  S := Format('%s (%s, line %d, address $%x)',
    [Message, Filename, LineNumber, Pred(Integer(ErrorAddr))]);
  OutputDebugString(PChar(S));
end;

procedure AssertErrorNoHandler(const Message, Filename: string; LineNumber: Integer; ErrorAddr: Pointer);
begin
end;

initialization
  if FindCmdLineSwitch('Debug', ['/', '-'], True) then
    AssertErrorProc := @AssertErrorHandler
  else
    AssertErrorProc := @AssertErrorNoHandler
end. 
