unit BeginUpdate;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, 
  Controls, Forms, Dialogs, StdCtrls, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    StatusBar1: TStatusBar;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: BeginUpdate
// Method: Classes.TCollection.BeginUpdate
// Method: Classes.TCollection.EndUpdate
// Method: ComCtrls.TStatusPanels.Add
// Property: Classes.TCollection.Count
// Property: ComCtrls.TStatusPanels.Items

// BeginCode
{
The following example adds a panel to the status bar control
when the user clicks the button and adds a caption to the 
panel. The code uses BeginUpdate and EndUpdate to prevent 
repaints until the operation is complete.  A try...finally 
block ensures EndUpdate is called even when an exception 
occurs.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  PanelIndex : Integer;
begin
  with StatusBar1 do
  begin
    Panels.BeginUpdate;
    PanelIndex := StatusBar1.Panels.Count - 1;
    try
      Panels.Add;
      Inc(PanelIndex);
      Panels.Items[PanelIndex].Text := 
      	'Panel' + IntToStr(PanelIndex);
    finally
      Panels.EndUpdate;
    end;
  end;
end;
// EndCode
// EndExample: BeginUpdate
end.
