
(*
 Delphi Object and Component Reference
# {bmc bm10.BMP} BeginUpdate, EndUpdate, Add, Count, Items example
{
The following example adds a panel to the status bar control
when the user clicks the button and adds a caption to the 
panel. The code uses BeginUpdate and EndUpdate to prevent 
repaints until the operation is complete.  A try...finally 
block ensures EndUpdate is called even when an exception occurs.
*) 
procedure TForm1.Button1Click(Sender: TObject);
var
  PanelIndex : Integer;
begin
  with StatusBar1 do
  begin
    Panels.BeginUpdate;
    PanelIndex := StatusBar1.Panels.Count - 1;
    try
      Panels.Add;
      Inc(PanelIndex);
      Panels.Items[PanelIndex].Text := 'Panel' + IntToStr(PanelIndex);
    finally
      Panels.EndUpdate;
    end;
  end;
end; 
