unit BlockRead;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: BlockRead
// Routine: System.BlockRead
// Routine: System.BlockWrite
// Routine: System.Close
// Routine: System.CloseFile
// Class: Dialogs.TSaveDialog
// Routine: System.Rewrite

// BeginCode
{
This example reads an entire file into a buffer with one
command and then writes it into a saved file.  Validate
the saved file contents.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  FromF, ToF: file;
  NumRead, NumWritten: Integer;
  Buf: array[1..2048] of Char;
begin
  if OpenDialog1.Execute then     { Display Open dialog box }
  begin
    AssignFile(FromF, OpenDialog1.FileName);
    Reset(FromF, 1);	{ Record size = 1 }
    if SaveDialog1.Execute then      { Display Save dialog box}
    begin
      AssignFile(ToF, SaveDialog1.FileName);	{ Open output file }
      Rewrite(ToF, 1);	{ Record size = 1 }
      Canvas.TextOut(10, 10, 'Copying ' + IntToStr(FileSize(FromF))
        + ' bytes...');
      repeat
        System.BlockRead(FromF, Buf, SizeOf(Buf), NumRead);
        BlockWrite(ToF, Buf, NumRead, NumWritten);
      until (NumRead = 0) or (NumWritten <> NumRead);
      // Use CloseFile rather than Close; Close provided for backward compatibility
      CloseFile(FromF);
      CloseFile(ToF);
      Canvas.TextOut(120, 10, ' done.');
    end;
  end;
end;
// EndCode
// EndExample: BlockRead
end.
