unit BoundsRect;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    ButtonSF: TButton;
    TabControl1: TTabControl;
    ComboBox1: TComboBox;
    ListView1: TListView;
    ButtonTS: TButton;
    procedure ButtonSFClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ListView1SelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure ButtonTSClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  myActiveControl: TWinControl;
implementation

{$R *.dfm}

// BeginExample: BoundsRect
// Property: Controls.TControl.BoundsRect
// Event: ComCtrls.TCustomListView.OnSelectItem
// Method: Classes.TComponent.FindComponent

// BeginCode
{
This code resizes the active control to twice as wide and
half as high:
}
procedure TForm1.ButtonSFClick(Sender: TObject);
var
  MyRect: TRect;
begin
  if (myActiveControl = nil) then exit;
  MyRect := myActiveControl.BoundsRect;
  MyRect.Right := MyRect.Left + (MyRect.Right - MyRect.Left) * 2;
  MyRect.Bottom := MyRect.Top + (MyRect.Bottom - MyRect.Top) div 2;
  myActiveControl.BoundsRect := MyRect;
end;

procedure TForm1.ButtonTSClick(Sender: TObject);
var
  MyRect: TRect;
begin
  if (myActiveControl = nil) then exit;
  MyRect := myActiveControl.BoundsRect;
  MyRect.Right := MyRect.Left + (MyRect.Right - MyRect.Left) div 2;
  MyRect.Bottom := MyRect.Top + (MyRect.Bottom - MyRect.Top) * 2;
  myActiveControl.BoundsRect := MyRect;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  I: Integer;
  Temp: TComponent;
  ListItem: TListItem;
begin
  ListView1.ViewStyle := vsList;
  ListItem := ListView1.Items.Add;
  ListItem.Caption := 'Components: ';
  for I := ComponentCount - 1 downto 0 do
  begin
    Temp := Components[I];
    begin
      ListItem := ListView1.Items.Add;
      ListItem.Caption := Temp.Name;
    end;
  end;
end;

procedure TForm1.ListView1SelectItem(Sender: TObject; Item: TListItem;
  Selected: Boolean);
var comp: TComponent;
begin
  comp := FindComponent(Item.Caption);
  if comp is TWinControl then
    myActiveControl := TWinControl(comp);
end;
// EndCode
// EndExample: BoundsRect
end.
