unit BrushCopy;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: BrushCopy
// Method: Graphics.TCanvas.BrushCopy
// Method: Graphics.TCanvas.CopyRect

// BeginCode
{
The following code illustrates the differences between 
CopyRect and BrushCopy. The bitmap graphic FACTORY.BMP is
loaded into Bitmap and displayed on the Canvas of Form1. 
BrushCopy replaces the color black in the graphic with the 
brush of the canvas, while CopyRect leaves the colors intact.
} 
procedure TForm1.Button1Click(Sender: TObject);
var
  Bitmap: TBitmap;
  MyRect, MyOther: TRect;
begin
  MyRect := Rect(10,10,150,150);
  MyOther := Rect(10,161,150,301);
  Bitmap := TBitmap.Create;
  Bitmap.LoadFromFile(
    'c:\Program Files\Common Files\CodeGear Shared\Images\Splash\256color\factory.bmp');
  Form1.Canvas.BrushCopy(MyRect, Bitmap, MyRect, clBlack);
  Form1.Canvas.CopyRect(MyOther,Bitmap.Canvas,MyRect);
  Bitmap.Free;
end;
// EndCode
// EndExample: BrushCopy
end.
