unit ButtonControlChecked;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    CheckBox1: TCheckBox;
    PageControl1: TPageControl;
    procedure CheckBox1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ButtonControlChecked
// Property: ComCtrls.TCustomTabControl.MultiLine
// Property: StdCtrls.TButtonControl.Checked

// BeginCode
{
This example requires a PageControl with no pages created,
and a TCheckBox. During the form create, a series of tabs
will be created on the Page Control that exceed the Page
Control's width.  When the Check Box control is clicked, the
setting of the MultiLine property is toggled, alternately
stacking the tabs vertically, or along a single line
horizontally.
} 
procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  PageControl1.MultiLine := CheckBox1.Checked;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  Checkbox1.Caption := 'Stack Tabs?';
  for i := 0 to 20 do
    with TTabSheet.Create(Self) do
    begin
      PageControl := PageControl1;
      Caption := 'Tab #' + IntToStr(i);
    end;
end;
// EndCode
// EndExample: ButtonControlChecked
end.
