unit ChDir;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, FileCtrl, StdCtrls, CustomizeDlg;

type
  TForm1 = class(TForm)
    DriveComboBox1: TDriveComboBox;
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    CustomizeDlg1: TCustomizeDlg;
    procedure DriveComboBox1Change(Sender: TObject);
    procedure DirectoryListBox1Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ChDir
// Routine: System.ChDir
// Routine: SysUtils.GetCurrentDir

// BeginCode
{
This example shows how to change and display the current
directory through text.  This example requires that a drive
combo box, a file list box, and a directory list box are on
a form. Add this code as the OnChange event handler for the
drive combo box and the OnChange event handler for the
directory list box.  When the user changes the drive using
the combo box, the directory list box and file list box will
update to reflect the new drive and the current directory on
that drive.  When the user double clicks on a directory in
the file list box will update to reflect the new directory.
}
procedure TForm1.Button1Click(Sender: TObject);
begin
  System.ChDir(Edit1.Text);
  if IOResult <> 0 then
    MessageDlg('Cannot find directory', mtWarning, [mbOk], 0);
  Edit2.Text := GetCurrentDir;
  FileListBox1.Directory := GetCurrentDir;
  DirectoryListBox1.Directory := GetCurrentDir;
end;

procedure TForm1.DirectoryListBox1Change(Sender: TObject);
begin
  FileListBox1.Directory := DirectoryListBox1.Directory;
  Edit2.Text := GetCurrentDir;
end;

procedure TForm1.DriveComboBox1Change(Sender: TObject);
begin
  DirectoryListBox1.Drive := DriveComboBox1.Drive;
  FileListBox1.Drive := DriveComboBox1.Drive;
  FileListBox1.Directory := DirectoryListBox1.Directory;
  Edit2.Text := GetCurrentDir;
end;
// EndCode
// EndExample: ChDir
end.
