unit ClassParent;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ClassParent
// Method: System.TObject.ClassParent
// Method: System.TObject.ClassType
// Method: System.TObject.ClassName
// Type: System.TClass

// BeginCode
{
This example shows how to obtain the ancestry of a component
using the ClassType and ClassParent properties. It uses a
button and a list box on a form. When the user clicks the
button, the name of the buttons class and the names of its
parent classes are added to the list box.
} 
procedure TForm1.Button1Click(Sender: TObject);
var
  ClassRef: TClass;
begin
  ListBox1.Clear;
  ClassRef := Sender.ClassType;
  while ClassRef <> nil do
  begin
    ListBox1.Items.Add(ClassRef.ClassName);
    ClassRef := ClassRef.ClassParent;
  end;
end;
{
The list box contains the following strings after the user clicks the button:
	TButton
	TButtonControl
	TWinControl or TWinControl
	TControl
	TComponent
	TPersistent
	TObject 
}
// EndCode
// EndExample: ClassParent
end.
