{
This example shows how to obtain the ancestry of a component using the ClassType and ClassParent properties. It uses a button and a list box on a form. When the user clicks the button, the name of the buttons class and the names of its parent classes are added to the list box.
} 
procedure TForm1.Button1Click(Sender: TObject);
var
  ClassRef: TClass;
begin
  ListBox1.Clear;
  ClassRef := Sender.ClassType;
  while ClassRef <> nil do
  begin
    ListBox1.Items.Add(ClassRef.ClassName);
    ClassRef := ClassRef.ClassParent;
  end;
end;
{
The list box contains the following strings after the user clicks the button:
	TButton
	TButtonControl
	TWinControl or TWinControl
	TControl
	TComponent
	TPersistent
	TObject 
}

