unit ClassesGetClass;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ClassesGetClass
// Method: Classes.TClassFinder.GetClass
// Routine: Classes.GetClass
// Routine: Graphics.GraphicExtension
// Routine: Classes.RegisterClasses
// Type: Graphics.TGraphicClass

// BeginCode
{
The following example allows users to type the name of a
graphics class into an edit control and when a button is
pressed, the name of the default extension for that class is
displayed in another edit control.  In the forms OnCreate
event handler (or a similar place) you must register the
graphics classes so that GetClass can find them.
}

uses ExtCtrls;

procedure TForm1.Button1Click(Sender: TObject);
var
  myClassFinder: TClassFinder;
  mygraphclass: TGraphicClass;
begin
  { make sure the classes are registered so that GetClass will work -- }
  { Usually, this goes in the initialization section where it is only executed once }
  RegisterClasses([TIcon, TBitmap, TButton, TShape, TImage, TMetafile]);
  try
    myClassFinder := TClassFinder.Create(TIcon, False);
    mygraphclass := TGraphicClass(myClassFinder.GetClass(Edit2.Text));
//    mygraphclass := TGraphicClass(GetClass(Edit2.Text));  // works as well
    Edit1.Text := GraphicExtension(mygraphclass);
  except
    on EAccessViolation do
      MessageDlg('Invalid class name.', mtError, [mbOK], 0)
  end;
end;
// EndCode
// EndExample: ClassesGetClass
end.
