unit ClientDataSet;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient;

type
  TForm1 = class(TForm)
    CDS: TClientDataSet;
    DS: TDataSource;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    Button1: TButton;
    Button2: TButton;
    CDSHOST: TStringField;
    CDSPORTA: TIntegerField;
    Button3: TButton;
    CDS2: TClientDataSet;
    DS2: TDataSource;
    DBGrid2: TDBGrid;
    Button4: TButton;
    Button5: TButton;
    DBNavigator2: TDBNavigator;
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ClientDataSet
// Method: DBClient.TCustomClientDataSet.LoadFromFile
// Method: DBClient.TCustomClientDataSet.SaveToFile
// Method: DBClient.TCustomClientDataSet.CreateDataSet
// Property: DBClient.TCustomClientDataSet.Data
// Method: DB.TDataSet.Close
// Class: DB.TDataSource
// Class: DBGrids.TDBGrid
// Class: DBCtrls.TDBNavigator
// Class: DB.TStringField
// Class: DB.TIntegerField

// BeginCode
{
This example requires two ClientDataSets, two DBGrids, two
DataSources and two DBNavigators.  Name the two
ClientDataSets CDS and CDS2. Set the DataSet property in the
first DataSource to CDS and name that DataSource DS.  Set the
DataSet property in the second DataSource to CDS2 and name
that DataSource DS2.  Set the DataSource in the first
DBNavigator to DS and the DataSource in the second DBNavigator
to DS2.  Set the DataSource in the first DBGrid to DS and the
DataSource in the second DBGrid to DS2.  Right click on CDS
and select the Fields Editor, then right click on the Field
Editor form and create two fields by selecting "new field".
In the field configuration window, set the name to HOST, the
Component value will automatically be set to CDSHOST.  Set
the filed type to String.  In the field configuration window
for the second field, set the name to PORTA, the Component
value will automatically be set to CDSPORTA.  Set the field
type to Integer.  The file used to load CDS must have an
attribute name of HOST with an attribute type of string and
an attribute name of PORTA with an attribute type of integer.
Add DB, DBCtrls, Grids, DBGrids, DBClient and SwSystem to the
uses clause.  "LoadFormFile" to start with the file, or 
"CreateDataSet" to start from scratch.  You must "CloseDataSet"
after a "LoadFromFile" before you can do another "CreateDataSet".
}
{$IFNDEF UNICODE}
uses SwSystem;
{$ENDIF}

procedure TForm1.Button1Click(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS.LoadFromFile(GetCurrentDir + '\CDS.XML');
{$ELSE}
  CDS.LoadFromFile(gsAppPath + 'CDS.XML');
{$ENDIF}
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS.SaveToFile(GetCurrentDir + '\CDS.XML', dfXML);
{$ELSE}
  CDS.SaveToFile(gsAppPath + 'CDS.XML', dfXML);
{$ENDIF}
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  CDS.CreateDataSet;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  CDS2.Data := CDS.Data;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  CDS.Close;
end;
// EndCode
// EndExample: ClientDataSet
end.
