unit ClientDataSetAddIndex;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient;

type
  TForm1 = class(TForm)
    CDS: TClientDataSet;
    DS: TDataSource;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    Button1: TButton;
    Button2: TButton;
    CDSHOST: TStringField;
    CDSPORTA: TIntegerField;
    Button3: TButton;
    Button5: TButton;
    QuickIndex: TButton;
    Edit1: TEdit;
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure QuickIndexClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ClientDataSetAddIndex
// Method: DBClient.TCustomClientDataSet.AddIndex

// BeginCode
{
The code below creates a new case-insensitive index at
runtime and then sorts the client dataset using that index.
The user specifies the field on which to sort the client
dataset in an edit control.
}
{$IFNDEF UNICODE}
uses SwSystem;
{$ENDIF}

procedure TForm1.QuickIndexClick(Sender: TObject);
begin
  if (Edit1.Text <> '') and
     (CDS.Fields.FindField(Edit1.Text) <> nil) then
  begin
    CDS.AddIndex(Edit1.Text + 'Index', Edit1.Text, [ixCaseInsensitive],'','',0);
    CDS.IndexName := Edit1.Text + 'Index';
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS.LoadFromFile(GetCurrentDir + '\CDS.XML');
{$ELSE}
  CDS.LoadFromFile(gsAppPath + 'CDS.XML');
{$ENDIF}
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS.SaveToFile(GetCurrentDir + '\CDS.XML', dfXML);
{$ELSE}
  CDS.SaveToFile(gsAppPath + 'CDS.XML', dfXML);
{$ENDIF}
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  CDS.CreateDataSet;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  CDS.Close;
end;
// EndCode
// EndExample: ClientDataSetAddIndex
end.
