unit ClientDataSetMoveBy;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient,
  ComCtrls;

type
  TForm1 = class(TForm)
    CDS: TClientDataSet;
    DS: TDataSource;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    Button1: TButton;
    Button2: TButton;
    CDSHOST: TStringField;
    CDSPORTA: TIntegerField;
    Button3: TButton;
    Button5: TButton;
    Button4: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure UpDownClick(Sender: TObject);
    procedure LeftRightClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{$IFNDEF UNICODE}
uses SwSystem;
{$ENDIF}

procedure TForm1.Button1Click(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS.LoadFromFile(GetCurrentDir + '\CDS.XML');
{$ELSE}
  CDS.LoadFromFile(gsAppPath + 'CDS.XML');
{$ENDIF}
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS.SaveToFile(GetCurrentDir + '\CDS.XML', dfXML);
{$ELSE}
  CDS.SaveToFile(gsAppPath + 'CDS.XML', dfXML);
{$ENDIF}
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  CDS.CreateDataSet;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  CDS.Close;
end;

// BeginExample: ClientDataSetMoveBy
// Method: DB.TDataSet.MoveBy
// Property: DBGrids.TCustomDBGrid.SelectedIndex
// Property: Classes.TComponent.Tag

// BeginCode
{
The following example enables the user to move the current
selected cell in a db grid.  The Up and Down buttons have
their OnClick events assigned to the UpDownClick procedure.
The Left and Right buttons have their OnClick events
assigned to the LeftRightClick procedure.  The Up and Left
buttons have their Tag property set to -1, while the Down
and Right buttons have their Tag property set to 1.  MoveBy
does not move the cell in the db grid, it only moves the
selection.  The data set is not edited.  Notice that the
Up button and the Down button are separate TButtons, not
one TUpDown.  The tags must be set different.
}
procedure TForm1.UpDownClick(Sender: TObject);
begin
  CDS.MoveBy(TComponent(Sender).Tag);
  DBGrid1.SetFocus;
end;

procedure TForm1.LeftRightClick(Sender: TObject);
begin
  DBGrid1.SelectedIndex := DBGrid1.SelectedIndex + TComponent(Sender).Tag;
  DBGrid1.SetFocus;
end;
// EndCode
// EndExample: ClientDataSetMoveBy
end.
