unit ClipRect;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Image1: TImage;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ClipRect
// Method: ExtCtrls.TImage.Canvas
// Method: Graphics.TCanvas.ClipRect
// Method: Controls.TControl.Invalidate

// BeginCode
{
This example creates a region and selects this region as the
clipping rectangle for the Image component's canvas. It then
sets the canvas's brush color to red and calls FillRect 
using the ClipRect as the area to fill. Lastly, the ClipRect
is reset to the original value that it contained by calling
SelectClipRect with nil as the second parameter and deletes
the region.  Place a TImage object in the form.
}
procedure TForm1.Button1Click(Sender: TObject);
var
    MyRgn: HRGN;
begin
    MyRgn := CreateRectRgn(100,100,200,200);
    SelectClipRgn(Image1.Canvas.Handle,MyRgn);
    Image1.Canvas.Brush.Color := clRed;
    Image1.Canvas.FillRect(Image1.Canvas.ClipRect);
    Image1.Invalidate;
    SelectClipRgn(Image1.Canvas.Handle, HRGN(nil));
    DeleteObject(MyRgn);
end;
// EndCode
// EndExample: ClipRect
end.
