unit ColorToRGB;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    RedEdit: TEdit;
    GreenEdit: TEdit;
    BlueEdit: TEdit;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ColorToRGB
// Routine: Graphics.ColorToRGB

// BeginCode
{
The following code converts the color of the current form,
Form1, to a Windows RGB value:
}
const
  NumPaletteEntries = 20;
var
  FPaletteEntries: array[0..NumPaletteEntries - 1] of TPaletteEntry;

procedure TForm1.Button1Click(Sender: TObject);
var
  I: Integer;
  Result: Integer;
  RealColor, paletteColor: TColor;
begin
  Result := 0;
  I := 0;
  RealColor := Graphics.ColorToRGB(Form1.Color);
  while I < NumPaletteEntries do
  begin
    with FPaletteEntries[I] do
    begin
      paletteColor:= TColor(RGB(peRed, peGreen, peBlue));
      if RealColor = paletteColor then
      begin
        Label1.Caption := IntToStr(I);
        RedEdit.Text:= IntToStr(peRed);
        GreenEdit.Text:= IntToStr(peGreen);
        BlueEdit.Text:= IntToStr(peBlue);
        Exit;
      end;
    end;
    Inc(I)
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Form1.Color:=
    StrToInt(RedEdit.Text) shl 16 +
    StrToInt(GreenEdit.Text) shl 8 +
    StrToInt(BlueEdit.Text);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  GetPaletteEntries(GetStockObject(DEFAULT_PALETTE), 0, NumPaletteEntries,
    FPaletteEntries);
  Form1.Color:= clMoneyGreen;
end;
// EndCode
// EndExample: ColorToRGB
end.
