unit ComboBox;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm3 = class(TForm)
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    comb : TComboBox;
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

{$R *.dfm}

// BeginExample: TComboBox
// Class: StdCtrls.TComboBox
// Method: StdCtrls.TCustomCombo.AddItem
// Property: Controls.TCustomListControl.ItemIndex
// Property: StdCtrls.TCustomComboBox.AutoComplete

// BeginCode
{
This is a very simple example showing how to create a comboBox, add to
it some choices, selecting a default value and getting the selected
value.
}
procedure TForm3.Button1Click(Sender: TObject);
begin
  MessageDlg('Selected text: ' + comb.Text, mtInformation,
            mbYesNo, 0);
end;

procedure TForm3.FormCreate(Sender: TObject);
begin
  //initialize the combo box
  comb := TComboBox.Create(Self);
  comb.Parent := Self;

  //visual options
  comb.Align := alLeft;
  comb.DoubleBuffered := true;
  comb.AutoComplete := true;

  //adding items to the combo box
  comb.AddItem('firstChoice', nil);
  comb.AddItem('secondChoice', nil);
  comb.AddItem('thirdChoice', nil);

  //setting the default value
  comb.ItemIndex := 1;
end;
// EndCode
// EndExample: TComboBox

end.
