{*******************************************************}
{                                                       }
{        Midas RemoteDataModule Pooler Demo             }
{                                                       }
{*******************************************************}

unit clntfrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBClient, Db, Grids, DBGrids, StdCtrls, MConnect, Variants;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    DBGrid1: TDBGrid;
    ClientDataSet1: TClientDataSet;
    RemoteServer1: TDCOMConnection;
    DataSource1: TDataSource;
//    CDSClone: TClientDataSet;
    Button2: TButton;
    Button3: TButton;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
    procedure CheckButtonActive(DataSet: TDataSet);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{
Build the group project to generate server.exe and client.exe.
Run the server first by selecting server.exe and Run Without
Debugging, or execute server.exe outside of Delphi.  Then run
client.exe.  Click "Run SQL" first, then "GetNextPacket".
}

procedure TForm1.Button2Click(Sender: TObject);
begin
  ClientDataSet1.PacketRecords := StrToInt(Edit1.Text);
  ClientDataSet1.GetNextPacket;
end;

// BeginExample: CommandText
// Property: DBClient.TCustomClientDataSet.CommandText

// BeginCode
{
The following code fragment illustrates how DataSets and
DataSetCount can be used to ensure that an action is taken
for every open dataset.  Assign CheckButtonActive as the
AfterClose and AfterOpen event handlers for TClientDataSet1.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  I: Integer;
begin
  if not RemoteServer1.Connected then
    RemoteServer1.Connected := True;
  ClientDataSet1.Close;
  with RemoteServer1 do
  begin
    for I := 0 to DataSetCount - 1 do
      DataSets[I].EnableControls;
  end;
  // Memo1 must contain a "select * from xxx" employee, customer, client
  // Look in Program Files/Common Files/CodeGear Shared/Data for db files
  // Notice, using the CommandText, don't need a BeforeGetRecords event
  // handler for the ClientDataSet or the DataSetProvider.

  ClientDataSet1.CommandText := Memo1.Lines.Text;
  ClientDataSet1.Open;
end;
// EndCode
// EndExample: CommandText

procedure TForm1.Button3Click(Sender: TObject);
var
  I: Integer;
begin
  ClientDataSet1.Close;
  RemoteServer1.Connected := False;
  with RemoteServer1 do
  begin
    for I := 0 to DataSetCount - 1 do
      DataSets[I].DisableControls;
  end;
end;

procedure TForm1.CheckButtonActive(DataSet: TDataSet);
begin
  Button1.Enabled := not ClientDataSet1.Active;
  Button2.Enabled := ClientDataSet1.Active;
  Button3.Enabled := ClientDataSet1.Active;
end;

procedure TForm1.Memo1Change(Sender: TObject);
begin
  ClientDataSet1.Close;
end;
end.
