{*******************************************************}
{                                                       }
{        Midas RemoteDataModule Pooler Demo             }
{                                                       }
{*******************************************************}

unit srvrdm;

{
  This is the Remote Data Module (RDM) that is going to be pooled.
  The differences between this RDM and a regular RDM are as follows;
  1) In order to share RDMs the client must be stateless. This means that the
     all calls that come into the server, must not rely on any informatin passed
     in previous calls.
  2) The RDMs need to run in their own thread which is why the factory
     constructor is specifying tmApartment as the threading model.  tmFree or
     tmBoth could also be used if the server is written to support Free threading.
  3) This class is an internal accesible class only and is not registered in the
     registry.  All access to this object is done from the pooler object.  If
     you look in the Type Library you will see 2 different CoClasses for this
     project.  One is for this class and one is for the Pooler.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComServ, ComObj, VCLCom, StdVcl, ActiveX, DataBkr, Server_TLB,
  Db, DBTables, Provider, Variants;

type
  TPooledRDM = class(TRemoteDataModule, IPooledRDM)
    Session1: TSession;
    Database1: TDatabase;
    Query1: TQuery;
    DataSetProvider1: TDataSetProvider;
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
{ Need a reference to the ClassFactory so the pooler can create instances of the
  class. }
  RDMFactory: TComponentFactory;

implementation

{$R *.dfm}

class procedure TPooledRDM.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

initialization
  RDMFactory := TComponentFactory.Create(ComServer, TPooledRDM,
    Class_PooledRDM, ciInternal, tmApartment);
end.
