unit CompConversion;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm2 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    Button1: TButton;
    Edit3: TEdit;
    Edit4: TEdit;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.dfm}

// BeginExample: CompConversion
// Routine: System.CompToCurrency
// Routine: System.CompToDouble

// BeginCode
{
This example demonstrates Comp conversion functions.
}

procedure TForm2.Button1Click(Sender: TObject);
var
  CompValue: Comp;
  CurrencyValue: Currency;
begin
  try
    CompValue := StrToInt64(Edit1.Text);
    CurrencyValue := CompToCurrency(CompValue);
    Edit2.Text := CurrToStr(CurrencyValue);
  except
    MessageDlg('Enter a signed integer with abs value <= 9 * 10**18', mtError, [mbOK], 0);
  end;
end;

procedure TForm2.Button2Click(Sender: TObject);
var
  CompValue: Comp;
  DoubleValue: Double;
begin
  try
    CompValue := StrToInt64(Edit3.Text);
    DoubleValue := CompToDouble(CompValue);
    Edit4.Text := FloatToStr(DoubleValue);
  except
    MessageDlg('Enter a signed integer with abs value <= 9 * 10**18', mtError, [mbOK], 0);
  end;
end;

// EndCode
// EndExample: CompConversion

procedure TForm2.FormCreate(Sender: TObject);
begin
  Edit1.Text := '-123';
  Edit2.Text := '';
  Edit3.Text := '456';
  Edit4.Text := '';
end;

end.
