unit ComponentCount;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, ActnList, ImgList, Grids, DBGrids, StdCtrls,
  ComponentCount2;


type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    ImageList1: TImageList;
    ActionList1: TActionList;
    MainMenu1: TMainMenu;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ComponentCountProperty
// Property: Classes.TComponent.ComponentCount
// Property: Classes.TComponent.Components
// Method: Classes.TComponent.RemoveComponent
// Method: Classes.TComponent.InsertComponent

// BeginCode
{
This code fragment moves any nonvisual components on the 
form into a separate data module. Note that the components 
are removed starting with the last component, so that the 
unprocessed portion of the Components array does not change.
Note: This code does not save the form or data module to disk
after the nonvisual components are moved.  If executed at 
runtime, the effect will not persist.
Add a second TForm and name it ComponentCount2.  Put 
"ComponentCount2" at the end of the uses clause of Form1.  
Place a TMemo in each form and a TButton in Form1.
} 

procedure TForm1.Button1Click(Sender: TObject);
var
  I: Integer;
  Temp: TComponent;
begin
  Form1.Memo1.Lines.Add('Components removed: ');
  Form2.Memo1.Lines.Add('Components added: ');
  for I := ComponentCount - 1 downto 0 do
  begin
    Temp := Components[I];
    if not (Temp is TControl) then
    begin
      RemoveComponent(Temp);
      Form1.Memo1.Lines.Add(Temp.Name);
      Form2.InsertComponent(Temp);
      Form2.Memo1.Lines.Add(Temp.Name);
    end;
  end;
end;
// EndCode
// EndExample: ComponentCountProperty

procedure TForm1.FormShow(Sender: TObject);
begin
  Form2.Show;
end;

end.
