unit ControlMargins;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm2 = class(TForm)
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.dfm}

// BeginExample: ControlMargins
// Property: Controls.TControl.AlignWithMargins
// Property: Controls.TControl.Margins
// Class: Controls.TMargins
// Method: Controls.TControl.SetBounds

// BeginCode
{
This example demostrates the usage of Margins and AlignWithMargins
properties. Note that Margins will only work when AlignWithMargins
is set to true and Align is not alNone.
}
const
  TopPanelMargin = 10;
  BottomPanelMargin = 30;

var
  TopPanel, BottomPanel : TPanel;

procedure TForm2.FormCreate(Sender: TObject);
begin
  { Create a new panel and align it to top }
  TopPanel := TPanel.Create(Self);
  TopPanel.Parent := Self;
  TopPanel.Align := alTop;
  TopPanel.Height := (ClientHeight div 2);

  { Create a new panel and align it to the remaining client size }
  BottomPanel := TPanel.Create(Self);
  BottomPanel.Parent := Self;
  BottomPanel.Align := alClient;

  { Set Top panel margins }
  { Note: Margins will not have an effect if Align is alNone }
  TopPanel.Margins.SetBounds(TopPanelMargin, TopPanelMargin,
                             TopPanelMargin, TopPanelMargin);
  TopPanel.AlignWithMargins := true;
  TopPanel.Caption:= 'TopPanel';

  { Set Bottom panel margins }
  { Note: Margins will not have an effect if Align is alNone }
  BottomPanel.Margins.SetBounds(BottomPanelMargin, BottomPanelMargin,
                               BottomPanelMargin, BottomPanelMargin);
  BottomPanel.AlignWithMargins := true;
  BottomPanel.Caption:= 'BottomPanel';

  if (TopPanel.Top <> TopPanelMargin) or
     (TopPanel.Left <> TopPanelMargin) or
     (TopPanel.Width <> (ClientWidth - (TopPanelMargin * 2))) or
     (BottomPanel.Top <> (TopPanel.Height + (TopPanelMargin * 2) +
                                               BottomPanelMargin)) or
     (BottomPanel.Left <> BottomPanelMargin) or
     (BottomPanel.Width <> (ClientWidth - (BottomPanelMargin * 2)))
     then
       MessageDlg('This should not happen! Position and size are ' +
            'calculated relative to the margins', mtError, [mbOK], 0);
end;
// EndCode
// EndExample: ControlMargins

procedure TForm2.Button1Click(Sender: TObject);
var
  topmargin, bottommargin, leftmargin, rightmargin: TPanel;
begin
  topmargin := TPanel.Create(Self);
  topmargin.Parent:= Self;
  topmargin.Left:= 0;
  topmargin.Width:= ClientWidth;
  topmargin.Top:= 0;
  topmargin.Height:= TopPanelMargin;
  topmargin.Color:= clYellow;
  topmargin.Caption:= 'topmargin';

  bottommargin := TPanel.Create(Self);
  bottommargin.Parent:= Self;
  bottommargin.Left:= 0;
  bottommargin.Width:= ClientWidth;
  bottommargin.Top:= ClientHeight - BottomPanelMargin;
  bottommargin.Height:= BottomPanelMargin;
  bottommargin.Color:= clYellow;
  bottommargin.Caption:= 'bottommargin';

  leftmargin := TPanel.Create(Self);
  leftmargin.Parent:= Self;
  leftmargin.Left:= 0;
  leftmargin.Width:= TopPanelMargin;
  leftmargin.Top:= 0;
  leftmargin.Height:= TopPanelMargin + TopPanel.Height;
  leftmargin.Color:= clYellow;
  leftmargin.Caption:= 'leftmargin';

  rightmargin := TPanel.Create(Self);
  rightmargin.Parent:= Self;
  rightmargin.Left:= ClientWidth - BottomPanelMargin;
  rightmargin.Width:= BottomPanelMargin;
  rightmargin.Top:= TopPanelMargin + TopPanel.Height + TopPanelMargin + BottomPanelMargin;
  rightmargin.Height:= BottomPanel.Height;
  rightmargin.Color:= clYellow;
  rightmargin.Caption:= 'rightmargin';
end;

end.
