unit CopyMode;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, Menus;

type
  TForm1 = class(TForm)
    Image1: TImage;
    Image2: TImage;
    MainMenu1: TMainMenu;
    Copy1: TMenuItem;
    Cut1: TMenuItem;
    procedure Cut1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: CopyMode
// Property: Graphics.TCanvas.CopyMode
// Property: Graphics.TCanvas.CopyRect

// BeginCode
{
The following example uses the CopyMode of an images canvas
to blank out the image when the user chooses the "Cut" menu 
item.  This example requires a Main menu with a Copy and a
Cut menu item that have their OnClick error handlers populated.
Note: CopyMode and CopyRect are members of the destination
canvas.
}
procedure TForm1.Copy1Click(Sender: TObject);
var
  DstRect, SrcRect: TRect;
begin
  with Image2.Canvas do
  begin
    CopyMode := cmSrcCopy;
    DstRect := Rect(0, 0, Image2.Width, Image2.Height);
    SrcRect := Rect(0, 0, Image1.Width, Image1.Height);
    CopyRect(DstRect, Image1.Canvas, SrcRect);
  end;
end;

procedure TForm1.Cut1Click(Sender: TObject);
var
  ARect: TRect;
begin
  Copy1Click(Sender); { do the same thing as the copy menu item }
  with Image1.Canvas do
  begin
    CopyMode := cmWhiteness;
    ARect := Rect(0, 0, Image1.Width, Image1.Height);
    CopyRect(ARect, Image1.Canvas, ARect);
    CopyMode := cmSrcCopy; { restore the copy mode }
  end;
end;
// EndCode
// EndExample: CopyMode

procedure TForm1.FormCreate(Sender: TObject);
begin
  Image1.Picture.LoadFromFile(
    'c:\Program Files\Common Files\CodeGear Shared\Images\Splash\256color\factory.bmp');
end;

end.
