unit CopyToClipboard;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    RichEdit1: TRichEdit;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: CopyToClipboard
// Method: StdCtrls.TCustomEdit.CopyToClipboard
// Method: StdCtrls.TCustomEdit.PasteFromClipboard

// BeginCode
{
This example uses an edit box, a rich edit control, and a
button on a form. When the user clicks the button, the first
line of text is copied from the rich edit control and pasted
into the edit box.  Note that only the text is pasted. If
the rich edit control includes any formatting information
that is not pasted into the edit control.  If the
destination were a rich edit control, the formatting
information would be copied as well.
}
procedure TForm1.Button1Click(Sender: TObject);
begin
  RichEdit1.SelectAll;
  RichEdit1.CopyToClipboard;
  Edit1.Clear;
  Edit1.PasteFromClipboard;
  RichEdit1.SetFocus;
end;

procedure TForm1.FormCreate(Sender: TObject);
const
  // you may need to change this path to suit your environment
  Path = 'OverView.RTF';
begin
  RichEdit1.PlainText := False;
  RichEdit1.Lines.LoadFromFile(Path);
  RichEdit1.ScrollBars := ssVertical;
end;
// EndCode
// EndExample: CopyToClipboard
end.
