unit CreateBlobStream;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, DBGrids, DB, DBTables, StdCtrls, DBClient, DBCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    ListBox1: TListBox;
    DBGrid2: TDBGrid;
    CDS2: TClientDataSet;
    DS2: TDataSource;
    Button1: TButton;
    DBMemo1: TDBMemo;
    DBMemo2: TDBMemo;
    DBNavigator1: TDBNavigator;
    DBNavigator2: TDBNavigator;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Stream1: TBlobStream;
  Table1Notes : TBlobField;

implementation

{$R *.dfm}

// BeginExample: CreateBlobStream
// Method: DB.TDataSet.CreateBlobStream
// Method: DBTables.TBlobStream.Create
// Method: DB.TDataSet.Edit
// Method: DB.TDataSet.FieldByName
// Method: Classes.TStream.CopyFrom

// BeginCode
{
The following example copies the data in the Notes field of
Table1 or SQLDataSet1 to the Remarks field of ClientDataSet1.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  Stream1: TBlobStream;
  Stream2: TStream;
  blobType : TBlobType;
begin
  blobType := Table1Notes.BlobType;
  Stream1 := TBlobStream.Create(Table1Notes, bmRead);
  try
    CDS2.Edit;
    { heres a different way to create a blob stream }
    Stream2 := CDS2.CreateBlobStream(CDS2.FieldByName('Remarks'), bmReadWrite);
    try
      Stream2.CopyFrom(Stream1, Stream1.Size);
//    CDS2.Post;
//    CDS2.Active := True;
    finally
      Stream2.Free;
    end;
  finally
    Stream1.Free;
  end;
end;
// EndCode
// EndExample: CreateBlobStream

procedure TForm1.FormCreate(Sender: TObject);
var
  I : Integer;
  S : String;
  ft : TFieldType;
  myString: String;
begin
// These properties can also be set statically at design time.
  Table1.DatabaseName := 'DBDEMOS';
  Table1.TableName := 'MyBlobInfo.DB';
  DataSource1.DataSet := Table1;
  DBGrid1.DataSource := DataSource1;
  Table1.Active := True; // Do this last
  Table1Notes := nil;
  for I := 0 to Table1.FieldCount - 1 do
  begin
    S := Table1.Fields[I].FieldName;
    ft := Table1.Fields[I].DataType;
    case ft of
      ftFloat: myString := 'float';
      ftBoolean: myString := 'boolean';
      ftInteger: myString := 'integer';
      ftString: myString := 'string';
      ftCurrency: myString := 'currency';
      ftBlob:
      begin
        myString := 'blob';
        Table1Notes := TBlobField(Table1.Fields[I]);
      end;
      ftSmallint: myString := 'smallint';
      ftTime: myString := 'time';
      ftDate: myString := 'date';
      ftDateTime: myString := 'datetime';
      ftTypedBinary: myString := 'typedBinary';
      ftMemo: myString := 'memo';
      ftGraphic: myString := 'graphic';
      ftAutoInc: myString := 'autoinc';
      else myString := 'unknown';
    end;
    ListBox1.Items.Add('Field ' + S + ' is of type: ' + myString);
  end;
  if (Table1Notes <> nil) then
  begin
    with CDS2 do
    begin
      with FieldDefs.AddFieldDef do
      begin
        DataType := ftInteger;
        Name := 'Field1';
      end;
      with FieldDefs.AddFieldDef do
      begin
        DataType := ftBlob;
        Size := 10;
        Name := 'Remarks';
      end;
      with IndexDefs.AddIndexDef do
      begin
        Fields := 'Field1';
        Name := 'IntIndex';
      end;
      CreateDataSet;
      DBMemo2.DataField := 'Remarks';
    end;
  end;
end;

end.
