{
The following example copies the data in the Notes field of Table1 or SQLDataSet1 to the Remarks field of ClientDataSet1.
}
{ Windows-only: }
procedure TForm1.Button1Click(Sender: TObject);
var
  Stream1: TBlobStream;
  Stream2: TStream;
begin
  Stream1 := TBlobStream.Create(Table1Notes, bmRead);
  try
    ClientDataSet1.Edit;
    { heres a different way to create a blob stream } 
    Stream2 := ClientDataSet1.CreateBlobStream(ClientDataSet1.FieldByName('Remarks'), bmReadWrite);
    try
      Stream2.CopyFrom(Stream1, Stream1.Size);
      ClientDataSet1.Post;
    finally
      Stream2.Free;
    end;
  finally
    Stream1.Free;
  end;
end;

{ Cross-platform: }
procedure TForm1.Button1Click(Sender: TObject);
var
  Stream1, Stream2 : TStream;
begin
  Stream1 := SQLDataSet1.CreateBlobStream(SQLDataSet1.FieldByName('Notes', bmRead);
  try
    ClientDataSet1.Edit;
    Stream2 := ClientDataSet1.CreateBlobStream(ClientDataSet1.FieldByName('Remarks'), bmReadWrite);
    try
      Stream2.CopyFrom(Stream1, Stream1.Size);
      ClientDataSet1.Post;
    finally
      Stream2.Free;
    end;
  finally
    Stream1.Free;
  end;
end; 

