unit CreateDataSet;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient;

type
  TForm1 = class(TForm)
    Button2: TButton;
    CDS2: TClientDataSet;
    DS2: TDataSource;
    DBGrid2: TDBGrid;
    Button5: TButton;
    DBNavigator2: TDBNavigator;
    Button1: TButton;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{$IFNDEF UNICODE}
uses SwSystem;
{$ENDIF}

procedure TForm1.Button1Click(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS2.LoadFromFile(GetCurrentDir + '\CDS2.XML');
{$ELSE}
  CDS2.LoadFromFile(gsAppPath + 'CDS2.XML');
{$ENDIF}
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS2.SaveToFile(GetCurrentDir + '\CDS2.XML', dfXML);
{$ELSE}
  CDS2.SaveToFile(gsAppPath + 'CDS2.XML', dfXML);
{$ENDIF}
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  CDS2.Close;
end;

// BeginExample: CreateDataSet
// Method: DBClient.TCustomClientDataSet.CreateDataSet
// Property: DB.TDataSet.FieldDefs
// Method: DB.TFieldDefs.AddFieldDef
// Method: DB.TIndexDefs.AddIndexDef

// BeginCode
{
The following code creates and activates a client dataset in
the forms OnCreate event handler.
} 
procedure TForm1.FormCreate(Sender: TObject);
begin
  with CDS2 do
  begin
    with FieldDefs.AddFieldDef do
    begin
      DataType := ftInteger;
      Name := 'Field1';
    end;
    with FieldDefs.AddFieldDef do
    begin
      DataType := ftString;
      Size := 10;
      Name := 'Field2';
    end;
    with IndexDefs.AddIndexDef do
    begin
      Fields := 'Field1';
      Name := 'IntIndex';
    end;
    CreateDataSet;
  end;
end; 
// EndCode
// EndExample: CreateDataSet
end.
