unit CustomSort;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    ListView1: TListView;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: CustomSort
// Method: ComCtrls.TCustomListView.CustomSort
// Routine: SysUtils.CompareText

// BeginCode
{
The following code orders a list view in reverse
alphabetical order on the click of a button. The callback
function CustomSortProc calls the global CompareText
function and negates its return value.
}
function CustomSortProc(Item1, Item2: TListItem; ParamSort: integer): integer; stdcall;
begin
  Result := -CompareText(Item1.Caption,Item2.Caption);
end;
procedure TForm1.Button1Click(Sender: TObject);
begin
  ListView1.CustomSort(@CustomSortProc, 0);
end;

procedure TForm1.FormCreate(Sender: TObject);
var ListItem : TListItem;
begin
  ListView1.ViewStyle := vsList;
  ListItem := ListView1.Items.Add;
  ListItem.Caption := 'Apples';
  ListItem := ListView1.Items.Add;
  ListItem.Caption := 'Oranges';
  ListItem := ListView1.Items.Add;
  ListItem.Caption := 'Pears';
end;
// EndCode
// EndExample: CustomSort
end.
