unit D7ComboBox;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, StdCtrls, ComCtrls, ImgList;

type
  MyStringArray = array[0..2] of String;
  TComboForm = class(TForm)
    ComboBox1: TComboBox;
    MainMenu1: TMainMenu;
    ListView1: TListView;
    ImageList1: TImageList;
    procedure FormCreate(Sender: TObject);
    procedure ComboBox1Click(Sender: TObject);
  private
    var Col2Array: array[0..2] of String;
  public
    { Public declarations }
  end;

var
  ComboForm: TComboForm;

implementation

{$R *.dfm}

// BeginExample: ViewStyleProperty
// Property: ComCtrls.TCustomListView.ViewStyle
// Property: ComCtrls.TCustomListView.Column
// Property: ComCtrls.TCustomListView.Items
// Property: ComCtrls.TCustomListView.SmallImages
// Property: ComCtrls.TCustomListView.LargeImages
// Property: ComCtrls.TListItem.ImageIndex
// Method: Classes.TStrings.AddObject
// Method: Classes.TStrings.Objects
// Property: StdCtrls.TCustomCombo.Items
// Property: ImgList.TCustomImageList.Count
// Type: ComCtrls.TViewStyle

// BeginCode

{
This example requires a TListView, a TImageList and a 
TComboBox. You will need to double click the image list and 
add several images to the image list prior to running the 
project. You can use *.bmp or *.ico files from the 
\Images\Icons directory. During the forms OnCreate event 
handler, items for the List View control are created for 
each image in the Image List and the ImageIndex is assigned 
the number of the image within the ImageList. Two columns are
created so that when ViewStyle is vsReport, you will have 
columns to view.  Also within the forms OnCreate event 
handler assign the ComboBox each of the four TViewStyle 
constants to the Items Objects property. You could also 
simply code this within a series of OnClick event handlers 
as, for instance, ListView1.->ViewStyle := vsIcon.
}

procedure TComboForm.FormCreate(Sender: TObject);
var
  I: Integer;
  ListItem: TListItem;
  NewColumn: TListColumn;
begin
  Col2Array[0]:= 'Documentation for Image0.';
  Col2Array[1]:= 'Documentation for Image1.';
  Col2Array[2]:= 'Documentation for Image2.';
  // Create a ListView item for each image in the ImageList
  with ListView1 do
  begin
    SmallImages := ImageList1;
    LargeImages := ImageList1;
    for I := 0 to ImageList1.Count - 1 do
    begin
      ListItem := Items.Add;
      Listitem.Caption := 'Image' + IntToStr(I);
      ListItem.ImageIndex := I;
      Listitem.SubItems.Add(Col2Array[I]);
    end;
    // Create two columns to show during viewing as vsReport
    NewColumn := Columns.Add;
    NewColumn.Caption := 'Column 1';
    NewColumn.Width := 200;
    NewColumn := Columns.Add;
    NewColumn.Caption := 'Column 2';
    NewColumn.Width := 200;
    // Add View styles and constants to the Combo Box
    ComboBox1.Items.AddObject('vsIcon', TObject(vsIcon));
    ComboBox1.Items.AddObject('vsList', TObject(vsList));
    ComboBox1.Items.AddObject('vsReport', TObject(vsReport));
    ComboBox1.Items.AddObject(
      'vsSmallIcon', TObject(vsSmallIcon));
    // Display first item in the Combo Box
    ComboBox1.ItemIndex := 0;
  end;
end;

procedure TComboForm.ComboBox1Click(Sender: TObject);
begin
  with ComboBox1 do
    ListView1.ViewStyle := TViewStyle(Items.Objects[ItemIndex]);

end;
// EndCode
// EndExample: ViewStyleProperty
end.
