
(*
 Delphi Object and Component Reference
#{bmc bm10.BMP} Column, Items, ViewStyle, SmallImages, LargeImages, ImageIndex, AddObject, Objects example
This example requires a TListView, a TImageList and a TComboBox. You will need to double click the image list and add several images to the image list prior to running the project. You can use *.bmp or *.ico files from the \Images\Icons directory.
During the forms OnCreate event handler, items for the List View control are created for each image in the Image List and the ImageIndex is assigned the number of the image within the ImageList. Two columns are created so that when ViewStyle is vsReport, you will have columns to view.
Also within the forms OnCreate event handler assign the ComboBox each of the four TViewStyle constants to the Items Objects property. You could also simply code this within a series of OnClick event handlers as, for instance, ListView1.->ViewStyle := vsIcon.
*) 
procedure TForm1.FormCreate(Sender: TObject);
var
  I: Integer;
  ListItem: TListItem;
  NewColumn: TListColumn;
begin
  // Create a ListView item for each image in the ImageList
  with ListView1 do
  begin
    SmallImages := ImageList1;
    LargeImages := ImageList1;
    for I := 0 to ImageList1.Count - 1 do
    begin
      ListItem := Items.Add;
      Listitem.Caption := 'Image' + IntToStr(I);
      ListItem.ImageIndex := I;
    end;
    // Create two columns to show during viewing as vsReport
    NewColumn := Columns.Add;
    NewColumn.Caption := 'Column 1';
    NewColumn := Columns.Add;
    NewColumn.Caption := 'Column 2';
    // Add View styles and constants to the Combo Box
    ComboBox1.Items.AddObject('vsIcon', TObject(vsIcon));
    ComboBox1.Items.AddObject('vsList', TObject(vsList));
    ComboBox1.Items.AddObject('vsReport', TObject(vsReport));
    ComboBox1.Items.AddObject('vsSmallIcon', TObject(vsSmallIcon));
    // Display first item in the Combo Box
    ComboBox1.ItemIndex := 0;
  end;
end;

procedure TForm1.ComboBox1Click(Sender: TObject);
begin
  with ComboBox1 do
    ListView1.ViewStyle := TViewStyle(Items.Objects[ItemIndex]);
end;
 
