unit DefAttributes;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    RichEdit1: TRichEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: DefAttributes
// Property: ComCtrls.TCustomRichEdit.DefAttributes
// Property: ComCtrls.TCustomRichEdit.SelAttributes
// Property: ComCtrls.TTextAttributes.Color
// Property: ComCtrls.TTextAttributes.Height
// Property: ComCtrls.TTextAttributes.Style

// BeginCode
{
This example requires a TRichEdit and two TButtons. Leave
the default text, usually "RichEdit1", in the lines
property. The DefAttributes will apply to this text.
}
procedure TForm1.Button1Click(Sender: TObject);
begin
  with RichEdit1.SelAttributes do
  begin
    Color := clRed;
    Height := Height + 5;
  end;
  RichEdit1.Lines.Add('This line of text will be red.');
end;


procedure TForm1.Button2Click(Sender: TObject);
begin
  RichEdit1.DefAttributes.Color := clBlue;
  RichEdit1.DefAttributes.Style := [fsBold, fsItalic];
end;
// EndCode
// EndExample: DefAttributes
end.
