unit DirList;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, FileCtrl, StdCtrls;

type
  TForm1 = class(TForm)
    DriveComboBox1: TDriveComboBox;
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    FilterComboBox1: TFilterComboBox;
    Label1: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    procedure DriveComboBox1Change(Sender: TObject);
    procedure DirectoryListBox1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: DirList
// Method: FileCtrl.TFileListBox.ApplyFilePath
// Property: FileCtrl.TFileListBox.FileEdit
// Property: FileCtrl.TFilterComboBox.FileList
// Property: FileCtrl.TDirectoryListBox.DirLabel
// Property: FileCtrl.TDriveComboBox.DirList
// Property: FileCtrl.TDirectoryListBox.FileList
// Property: StdCtrls.TCustomButton.Default

// BeginCode
{
This example uses a file list box, a directory list box, a
filter combo box, a drive combo box, a label, an edit box,
and a button on a form. When the user runs the application
and enters a path or filename in the edit box and presses
the button, all the controls update:
} 
procedure TForm1.Button1Click(Sender: TObject);
begin
  FileListBox1.ApplyFilePath(Edit1.Text);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FileListBox1.FileEdit := Edit1;
  FilterComboBox1.FileList := FileListBox1;
  DirectoryListBox1.FileList := FileListBox1;
  DirectoryListBox1.DirLabel := Label1;
  DriveComboBox1.DirList := DirectoryListBox1;
  Button1.Default := True;
end;
// EndCode
// EndExample: DirList

procedure TForm1.DirectoryListBox1Change(Sender: TObject);
begin
  FileListBox1.Directory := DirectoryListBox1.Directory;
end;

procedure TForm1.DriveComboBox1Change(Sender: TObject);
begin
  DirectoryListBox1.Drive := DriveComboBox1.Drive;
  FileListBox1.Drive := DriveComboBox1.Drive;
  FileListBox1.Directory := DirectoryListBox1.Directory;
end;
end.
