unit DirListBoxDrive;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, FileCtrl, StdCtrls;

type
  TForm1 = class(TForm)
    DriveComboBox1: TDriveComboBox;
    FileListBox1: TFileListBox;
    DirectoryListBox1: TDirectoryListBox;
    procedure DriveComboBox1Change(Sender: TObject);
    procedure DirectoryListBox1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: DirListBoxDrive
// Property: FileCtrl.TDirectoryListBox.Directory
// Property: FileCtrl.TDirectoryListBox.Drive
// Property: FileCtrl.TDriveComboBox.Drive
// Property: FileCtrl.TFileListBox.Directory
// Property: FileCtrl.TFileListBox.Drive
// Event: FileCtrl.TDirectoryListBox.OnChange
// Event: StdCtrls.TCustomCombo.OnChange

// BeginCode
{
The following example assumes that a drive combo box, a file
list box, and a directory list box are on a form. Add this
code as the OnChange event handler for the drive combo box
and the OnChange event handler for the directory list box.
When the user changes the drive using the combo box, the
directory list box and file list box will update to reflect
the new drive and the current directory on that drive.  When
the user double clicks on a directory in the file list box
will update to reflect the new directory.
}
procedure TForm1.DirectoryListBox1Change(Sender: TObject);
begin
  FileListBox1.Directory := DirectoryListBox1.Directory;
end;

procedure TForm1.DriveComboBox1Change(Sender: TObject);
begin
  DirectoryListBox1.Drive := DriveComboBox1.Drive;
  FileListBox1.Drive := DriveComboBox1.Drive;
  FileListBox1.Directory := DirectoryListBox1.Directory;
end;
// EndCode
// EndExample: DirListBoxDrive
end.
