unit DirListBoxUpdate;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, FileCtrl;

type
  TForm1 = class(TForm)
    DirectoryListBox1: TDirectoryListBox;
    Button1: TButton;
    Button2: TButton;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: DirListBoxUpdate
// Method: FileCtrl.TDirectoryListBox.Update
// Routine: System.MkDir

// BeginCode
{
The following sample code sets the directory of
DirectoryListBox1 to C:\WINDOWS when the form is created.
When Button1 is pressed, a subdirectory called
mytemp is added to C:\WINDOWS, but note that it is not
updated in DirectoryListBox1 until Button2 is pressed
and Update is called.
Note: A EInOutError will occur if you add a directory that
already exists.  Also, you must add the new directory to
your current path to see the magic happen.
}

procedure TForm1.Button1Click(Sender: TObject);
begin
  MkDir(Edit1.Text);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  DirectoryListBox1.Update;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  DirectoryListBox1.Directory := 'c:\WINDOWS';
end;
// EndCode
// EndExample: DirListBoxUpdate
end.
