unit DisableControls;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient, SwSystem,
  DBTables, ComCtrls;

type
  TForm1 = class(TForm)
    DS2: TDataSource;
    DBGrid2: TDBGrid;
    DBNavigator2: TDBNavigator;
    Button1: TButton;
    ListBox1: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Flights: TTable;
implementation

{$R *.dfm}

// BeginExample: DisableControls
// Method: DB.TDataSet.DisableControls
// Method: DB.TDataSet.EnableControls
// Property: DB.TDataSet.Eof

// BeginCode
{
Usually DisableControls is called within the context of a
try...finally block that reenables the controls even if an
exception occurs. For example:
} 
procedure TForm1.Button1Click(Sender: TObject);
var
  i: Integer;
begin
  ListBox1.Clear;
  ListBox1.Items[0]:= 'Destination Airports:';
  with Flights do
  begin
    DisableControls;
    try
      First;
      i:= 1;
      ListBox1.Items[0]:= 'Destination Airports:';
      while not Eof do
      begin
        ListBox1.Items[i]:= Fields[2].Value;;
        i:= i + 1;
        Next;
      end;
    finally
      EnableControls;
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  Flights:= TTable.Create(Form1);
  with Flights do
  begin
    TableName := 'Flights';
    // This path depends on the Demos directory of your RAD Studio installation.
    DatabaseName :=
      'c:\Documents and Settings\All Users\Documents\RAD Studio\6.0\Demos\IntraWeb\Win32\FlightInformation\Data';

  end;
  DS2.DataSet:= Flights;
  DBGrid2.DataSource.DataSet:= Flights;
  Flights.Active:= True;
end;
// EndCode
// EndExample: DisableControls
end.
