{
OnUnDock, DockSite, DockClientCount example
The following example is taken from the docking demo. It shows how the OnUnDock event handler of the conjoinment docking site re-enables docking in the control that is undocked (if it is a dockable form). In addition, when the next to last docked control is undocked, the conjoinment docking site sends itself a close message so that the last docked control is undocked to its old position and size.
} 
procedure TConjoinDockHost.FormUnDock(Sender: TObject; Client: TControl; NewTarget: TWinControl; var Allow: Boolean);
begin
  //only 2 dock clients means the host must be destroyed and
  //the remaining window undocked to its old position and size.
  //(Recall that OnUnDock gets called before the undocking actually occurs)
  if Client is TDockableForm then
    TDockableForm(Client).DockSite := True;
  if (DockClientCount = 2) and (NewTarget <> Self) then
    PostMessage(Self.Handle, WM_CLOSE, 0, 0);
  UpdateCaption(Client);
end;
 
