unit DrawGridCol;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ImgList, StdCtrls;

type
  TForm1 = class(TForm)
    DrawGrid1: TDrawGrid;
    ImageList1: TImageList;
    Label1: TLabel;
    Label2: TLabel;
    procedure DrawGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure DrawGrid1SelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure DrawGrid1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: DrawGridCol
// Property: Grids.TCustomGrid.Col

// BeginCode
{
The following code uses the bitmaps in an image list
component to draw the contents of each cell in a draw grid.
It uses a draw grid with a label above it on a form. When
the user clicks a cell in the grid, the location of the
cursor is displayed in the label caption. This example
requires a populated image list, or can just display an
empty grid.
} 
procedure TForm1.DrawGrid1Click(Sender: TObject);
begin
  Label1.Caption := 'From OnClick: The cursor is in column ' +
                     IntToStr(DrawGrid1.Col + 1) + 
                     ', row ' +
                     IntToStr(DrawGrid1.Row + 1);
end;

procedure TForm1.DrawGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
var
  index: Integer;
begin
  index := ARow * DrawGrid1.ColCount + ACol;
  DrawGrid1.Canvas.Brush.Color := clBackground;
  DrawGrid1.Canvas.FillRect(Rect);
  ImageList1.Draw(DrawGrid1.Canvas,Rect.Left,Rect.Top,index, True);
  if (gdFocused in State) then
  begin
    DrawGrid1.Canvas.DrawFocusRect(Rect);
    Label2.Caption:= 'From OnDrawCell: Cell ' + InttoStr(index) + ' has the focus.';
  end;
end;

procedure TForm1.DrawGrid1SelectCell(Sender: TObject; ACol, ARow: Integer;
  var CanSelect: Boolean);
begin
  CanSelect:= True;
end;
// EndCode
// EndExample: DrawGridCol

end.
