unit DrawGridSelection;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ImgList, StdCtrls;

type
  TForm1 = class(TForm)
    DrawGrid1: TDrawGrid;
    ImageList1: TImageList;
    Label1: TLabel;
    Label2: TLabel;
    Button1: TButton;
    procedure DrawGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure DrawGrid1SelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure DrawGrid1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: DrawGridSelection
// Property: Grids.TCustomGrid.Selection

// BeginCode
{
The following code selects the rectangle containing rows 1
through 4, and columns 2 and 3.  goRangeSelect in the
DrawGrid Options parameter must be True to select a range of
cells.  This example requires a button, a DrawGrid and a 
populated ImageList.
}
procedure TForm1.Button1Click(Sender: TObject);
var
  myRect: TGridRect;
begin
  myRect.Left := 2;
  myRect.Top := 1;
  myRect.Right := 3;
  myRect.Bottom := 4;
  DrawGrid1.Selection := myRect;
  DrawGrid1.Repaint;
end;

procedure TForm1.DrawGrid1Click(Sender: TObject);
begin
  Label1.Caption := 'From OnClick: The cursor is in column ' +
                     IntToStr(DrawGrid1.Col + 1) + 
                     ', row ' +
                     IntToStr(DrawGrid1.Row + 1);
end;

procedure TForm1.DrawGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
var
  index: Integer;
begin
  index := (ARow * DrawGrid1.ColCount + ACol) mod (DrawGrid1.ColCount + 1);
  if (gdSelected in State) then
    DrawGrid1.Canvas.Brush.Color := clYellow
  else
    DrawGrid1.Canvas.Brush.Color := clBackground;
  DrawGrid1.Canvas.FillRect(Rect);
  if (gdFocused in State) then
  begin
    DrawGrid1.Canvas.DrawFocusRect(Rect);
    Label2.Caption:= 'From OnDrawCell: Cell ' + InttoStr(ARow * DrawGrid1.ColCount + ACol) +
      ' has the focus.';
  end;
  ImageList1.Draw(DrawGrid1.Canvas,Rect.Left,Rect.Top,index, True);
end;

procedure TForm1.DrawGrid1SelectCell(Sender: TObject; ACol, ARow: Integer;
  var CanSelect: Boolean);
begin
  CanSelect:= True;
end;
// EndCode
// EndExample: DrawGridSelection
end.
