unit EditMaskExample;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Mask;

type
  TForm1 = class(TForm)
    MaskEdit1: TMaskEdit;
    Label1: TLabel;
    Label2: TLabel;
    MaskEdit2: TMaskEdit;
    Label3: TLabel;
    MaskEdit3: TMaskEdit;
    procedure FormCreate(Sender: TObject);
    procedure MaskEdit2Exit(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: EditMask
// Property: Mask.TCustomMaskEdit.EditMask
// Property: Mask.TCustomMaskEdit.Text
// Event: Controls.TWinControl.OnExit

// BeginCode
{
This example uses three mask edit components on a form,
where the third mask edit box is set to be read only.
When the application runs, it initializes the mask edit boxes
to contain the empty string, to use the Courier font and to
use a particular mask, corresponding to IP address coding convetions.
The mask edit boxes display the IP address, the subnet mask
and the subnet address correspondingly. When the user exits the
subnet mask edit box, the subnet address is automatically calculated
using bit-wise AND operations and displayed in the third mask edit box.
An additional test is made to assure that the values in the IP address
and in the subnet mask are in the interval from 0 to 255,
as this validation test cannot be accomplished
using the edit mask property alone.
}
procedure TForm1.FormCreate(Sender: TObject);
begin
  { initialize the maskedit boxes to contain the empty string }
  MaskEdit1.Text := '';
  MaskEdit2.Text := '';
  MaskEdit3.Text := '';

  { use the Courier font in the maskedit boxes }
  MaskEdit1.Font.Name := 'Courier';
  MaskEdit2.Font.Name := 'Courier';
  MaskEdit3.Font.Name := 'Courier';

  {
  initialize the mask of each maskedit box
  according to IP address coding conventions
  }
  MaskEdit1.EditMask := '!099.099.099.099;1; ';
  MaskEdit2.EditMask := '!099.099.099.099;1; ';
  MaskEdit3.EditMask := '!099.099.099.099;1; ';

  MaskEdit2.OnExit := MaskEdit2Exit;
end;

procedure TForm1.MaskEdit2Exit(Sender: TObject);
var
  net1, net2, host1, host2,
  netmask1, netmask2, hostmask1, hostmask2,
  sub_net1, sub_net2, sub_host1, sub_host2: Integer;

  IP, mask: String;

begin
  // extract the net and host address from the IP
  IP := MaskEdit1.Text;
  net1 := StrToInt(TrimRight(Copy(IP, 0, 3)));
  net2 := StrToInt(TrimRight(Copy(IP, 5, 3)));
  host1 := StrToInt(TrimRight(Copy(IP, 9, 3)));
  host2 := StrToInt(TrimRight(Copy(IP, 13, 3)));

  // a range test that you cannot validate through edit masks
  if ((net1 < 0) Or (net1 > 255) Or
      (net2 < 0) Or (net2 > 255) Or
      (host1 < 0) Or (host1 > 255) Or
      (host2 < 0) Or (host2 > 255)) then
    raise EArgumentException.Create('Not a valid IP address.');

  // extract the net and host mask from the subnet mask
  mask := MaskEdit2.Text;
  netmask1 := StrToInt(TrimRight(Copy(mask, 0, 3)));
  netmask2 := StrToInt(TrimRight(Copy(mask, 5, 3)));
  hostmask1 := StrToInt(TrimRight(Copy(mask, 9, 3)));
  hostmask2 := StrToInt(TrimRight(Copy(mask, 13, 3)));

  // a range test that you cannot validate through edit masks
  if ((netmask1 < 0) Or (netmask1 > 255) Or
      (netmask2 < 0) Or (netmask2 > 255) Or
      (hostmask1 < 0) Or (hostmask1 > 255) Or
      (hostmask2 < 0) Or (hostmask2 > 255)) then
    raise EArgumentException.Create('Not a valid subnet mask.');

  // compute the subnet address using bit-wise AND
  sub_net1 := net1 And netmask1;
  sub_net2 := net2 And netmask2;
  sub_host1 := host1 And hostmask1;
  sub_host2 := host2 And hostmask2;

  // display the subnet address
  MaskEdit3.Text :=
    IntToStr(sub_net1) + '.' + IntToStr(sub_net2) + '.' +
    IntToStr(sub_host1) + '.' + IntToStr(sub_host2);
end;
// EndCode
// EndExample: EditMask

end.

