unit ExeName;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Save1: TButton;
    SaveDialog1: TSaveDialog;
    Label3: TLabel;
    Label4: TLabel;
    Edit3: TEdit;
    Edit2: TEdit;
    Label2: TLabel;
    Label5: TLabel;
    Edit4: TEdit;
    Edit1: TEdit;
    Label1: TLabel;
    procedure Save1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ExeName
// Property: Forms.TApplication.ExeName
// Method: Classes.TStream.CopyFrom
// Routine: SysUtils.ExtractFilePath
// Routine: SysUtils.Format
// Routine: AnsiStrings.Format
// Variable: Forms.Application

// BeginCode
{
This example copies a specified old file to a new file.  Add
a TSaveDialog to the form.  Also add two TEdits, two TLabels
and a TButton with the OnClick event named Save1Click. Change
the Old Path and New Path to move files outside the Debug
directory, Old File and New File will not take a relative path.
}
procedure TForm1.FormCreate(Sender: TObject);
begin
  Edit3.Text := ExtractFilePath(Application.ExeName);
  Edit4.Text := Edit3.Text;
end;

procedure TForm1.Save1Click(Sender: TObject);
var
  NewFileName, OldFileName: string;
  temp1, temp2: string;
  Msg: string;
  NewFile: TFileStream;
  OldFile: TFileStream;
begin
  temp1 := Edit4.Text;
  temp2 := ExtractFileName(Edit1.Text);
  NewFileName := temp1 + temp2;
  OldFileName :=
    Edit3.Text + ExtractFileName(Edit2.Text);
  Msg := Format('Copy %s to %s?', [OldFileName, NewFileName]);
  if MessageDlg(Msg, mtCustom, mbOKCancel, 0) = mrOK then
  begin
    OldFile := TFileStream.Create(
      OldFileName, fmOpenRead or fmShareDenyWrite);
    try
      NewFile := TFileStream.Create(
        NewFileName, fmCreate or fmShareDenyRead);
      try
        NewFile.CopyFrom(OldFile, OldFile.Size);
      finally
        FreeAndNil(NewFile);
      end;
    finally
      FreeAndNil(OldFile);
    end;
  end;
end; 
// EndCode
// EndExample: ExeName
end.
