{
This example copies a specified file into the same directory as the (cross-platform) application.
} 
procedure TForm1.Save1Click(Sender: TObject);
var
  NewFileName: string;
  Msg: string;
  NewFile: TFileStream;
  OldFile: TFileStream;
begin
  NewFileName := ExtractFilePath(Application.ExeName) + ExtractFileName(Edit1.Text);
  Msg := Format('Copy %s to %s?', [Edit1.Text, NewFileName]);
  if MessageDlg(Msg, mtCustom, mbOKCancel, 0) = mrOK then
  begin
    OldFile := TFileStream.Create(Edit1.Text, fmOpenRead or fmShareDenyWrite);
    try
      NewFile := TFileStream.Create(NewFileName, fmCreate or fmShareDenyRead);
      try
        NewFile.CopyFrom(OldFile, OldFile.Size);
      finally
        FreeAndNil(NewFile);
      end;
    finally
      FreeAndNil(OldFile);
    end;
  end;
end; 
