unit ExtractFileName;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    StringGrid1: TStringGrid;
    SaveDialog1: TSaveDialog;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: ExtractFileName
// Routine: SysUtils.FileExists
// Routine: SysUtils.RenameFile
// Routine: SysUtils.FileCreate
// Routine: SysUtils.FileWrite
// Routine: SysUtils.FileClose
// Routine: SysUtils.ExtractFileName
// Method: SysUtils.Exception.Create

// BeginCode
{
The following example uses a button, a string grid, and a
Save dialog box on a form. When the button is clicked, the
user is prompted for a filename. When the user clicks OK,
the contents of the string grid are written to the specified
file. Additional information is also written to the file so
that it can be read easily with the FileRead function.
} 
procedure TForm1.Button1Click(Sender: TObject);
var
  BackupName: string;
  FileHandle: Integer;
  StringLen: Integer;
  X, Y, I: Integer;
  colCountLength, rowCountLength: Integer;
  Buffer: PChar;
  cellString: string;
begin
  if SaveDialog1.Execute then
  begin
    if FileExists(SaveDialog1.FileName) then
    begin
      BackupName := SysUtils.ExtractFileName(SaveDialog1.FileName);
      BackupName := ChangeFileExt(BackupName, '.BAK');
      if not RenameFile(SaveDialog1.FileName, BackupName) then
        raise Exception.Create('Unable to create backup file.');
    end;
    FileHandle := FileCreate(SaveDialog1.FileName);
    { Write out the number of rows and columns in the grid. }
    colCountLength := SizeOf(StringGrid1.ColCount);
    FileWrite(FileHandle, 
      Pchar(StringGrid1.ColCount), colCountLength);
    rowCountLength := SizeOf(StringGrid1.RowCount);
    FileWrite(FileHandle,
      PChar(StringGrid1.RowCount), rowCountLength);
    for X := 0 to StringGrid1.ColCount - 1 do
    begin
      for Y := 0 to StringGrid1.RowCount - 1 do
      begin
        try
          { Write out the length of each string, followed by the string itself. }
          StringLen := Length(StringGrid1.Cells[X,Y]);
          FileWrite(FileHandle, PChar(StringLen), SizeOf(StringLen));
          GetMem(Buffer, StringLen); { allocate the buffer }
          cellString := StringGrid1.Cells[X,Y];
          for I := 1 to StringLen do
             Buffer[I - 1] := cellString[I];
          FileWrite(FileHandle, Buffer^, StringLen);
        finally
          FreeMem(Buffer, StringLen);
        end;
      end;
    end;
    FileClose(FileHandle);
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  with StringGrid1 do
  begin
    Cells[1,0] := 'Column 1';
    Cells[2,0] := 'Column 2';
    Cells[3,0] := 'Column 3';
    Cells[4,0] := 'Column 4';
    Cells[0,1] := 'Row 1';
    Cells[1,1] := 'Object';
    Cells[2,1] := 'Pascal';
    Cells[3,1] := 'is';
    Cells[4,1] := 'excellent';
    Cells[0,2] := 'Row 2';
    Cells[1,2] := 'Delphi';
    Cells[2,2] := 'is';
    Cells[4,2] := 'RAD';
  end;
end;
// EndCode
// EndExample: ExtractFileName
end.
