unit FetchParams;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DBClient, Provider;

type
  TForm1 = class(TForm)
    CDS: TClientDataSet;
    DS: TDataSource;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    Button1: TButton;
    Button2: TButton;
    CDSHOST: TStringField;
    CDSPORTA: TIntegerField;
    Button3: TButton;
    CDS2: TClientDataSet;
    DS2: TDataSource;
    DBGrid2: TDBGrid;
    Button4: TButton;
    Button5: TButton;
    DBNavigator2: TDBNavigator;
    SaveParams: TButton;
    AlterParams: TButton;
    RestoreParams: TButton;
    ListBox1: TListBox;
    DataSetProvider1: TDataSetProvider;
    DataSetProvider2: TDataSetProvider;
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SaveParamsClick(Sender: TObject);
    procedure AlterParamsClick(Sender: TObject);
    procedure RestoreParamsClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{$IFNDEF UNICODE}
uses SwSystem;
{$ENDIF}

procedure TForm1.Button1Click(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS.LoadFromFile(GetCurrentDir + '\CDS.XML');
{$ELSE}
  CDS.LoadFromFile(gsAppPath + 'CDS.XML');
{$ENDIF}
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
{$IFDEF UNICODE}
  CDS.SaveToFile(GetCurrentDir + '\CDS.XML', dfXML);
{$ELSE}
  CDS.SaveToFile(gsAppPath + 'CDS.XML', dfXML);
{$ENDIF}
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  CDS.CreateDataSet;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  CDS2.Data := CDS.Data;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  CDS.Close;
end;

var SavedParams: TParams;

// BeginExample: FetchParams
// Method: DBClient.TCustomClientDataSet.FetchParams
// Property: DBClient.TCustomClientDataSet.Params
// Property: DB.TParam.DataType
// Property: DB.TParams.Items
// Routine: SysUtils.StrToIntDef

// BeginCode
{
  This example uses the FetchParams method to sync the params
  with the server.
}
procedure TForm1.SaveParamsClick(Sender: TObject);
begin
  { Save the parameters for the TDataSet }
  SavedParams.Assign(CDS.Params);
end;

procedure TForm1.AlterParamsClick(Sender: TObject);
var
  I : Integer;
  ListItem: string;
begin
  CDS.Params.CreateParam(ftString, 'stringParam', ptInput);  // you can also edit the params in the CDS dynamically
  CDS.Params.CreateParam(ftSmallInt, 'smallIntParam', ptInput);
  CDS.Params.CreateParam(ftInteger, 'intParam', ptInput);
  CDS.Params.CreateParam(ftWord, 'wordParam', ptInput);
  CDS.Params.CreateParam(ftBoolean, 'boolParam', ptInput);
  CDS.Params.CreateParam(ftFloat, 'floatParam', ptInput);
  CDS.Params.CreateParam(ftCurrency, 'currencyParam', ptInput);
  CDS.Params.CreateParam(ftBCD, 'bcdParam', ptInput);
  CDS.Params.CreateParam(ftDate, 'dateParam', ptInput);
  CDS.Params.CreateParam(ftTime, 'timeParam', ptInput);
  CDS.Params.CreateParam(ftDateTime, 'dateTimeParam', ptInput);
  { Call FetchParams to ensure parameters reflect server metadata }
  CDS.FetchParams;
  with CDS.Params do
  begin
    for I := 0 to Count - 1 do
    begin
      ListItem := ListBox1.Items[I];
      case Items[I].DataType of
        ftString:
          Items[I].AsString := ListItem;
        ftSmallInt:
          Items[I].AsSmallInt := StrToIntDef(ListItem, 0);
        ftInteger:
          Items[I].AsInteger := StrToIntDef(ListItem, 0);
        ftWord:
          Items[I].AsWord := StrToIntDef(ListItem, 0);
        ftBoolean:
          begin
            if ListItem = 'True' then
              Items[I].AsBoolean := True
            else
              Items[I].AsBoolean := False;
          end;
        ftFloat:
          Items[I].AsFloat := StrToFloat(ListItem);
        ftCurrency:
          Items[I].AsCurrency := StrToFloat(ListItem);
        ftBCD:
          Items[I].AsBCD := StrToCurr(ListItem);
        ftDate:
          Items[I].AsDate := StrToDate(ListItem);
        ftTime:
          Items[I].AsTime := StrToTime(ListItem);
        ftDateTime:
          Items[I].AsDateTime := StrToDateTime(ListItem);
      end;
    end;
  end;
end;

procedure TForm1.RestoreParamsClick(Sender: TObject);
begin
  { Restore the parameters to TDataSet }
  CDS.Params.AssignValues(SavedParams);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  { Initialize SavedParams }
  SavedParams := TParams.Create;
  ListBox1.Items.Add('Here is a string');
  ListBox1.Items.Add('4');
  ListBox1.Items.Add('3456789');
  ListBox1.Items.Add('34');
  ListBox1.Items.Add('0');
  ListBox1.Items.Add('12.56');
  ListBox1.Items.Add('4.23');
  ListBox1.Items.Add('99.5');
  ListBox1.Items.Add('4/12/53');
  ListBox1.Items.Add('7:45:00');
  ListBox1.Items.Add('4/12/53 7:45:00');
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  SavedParams.Free;
end;
// EndCode
// EndExample: FetchParams
end.
