
(*
 Delphi Object and Component Reference
 ParamCount, DataType, StrToIntDef, AsXXX example
This example fills in the parameters of a query from the entries of a list box.
*) 
var
  I: Integer;
  ListItem: string;
begin
  for I := 0 to Query1.ParamCount - 1 do
  begin
    ListItem := ListBox1.Items[I];
    case Query1.Params[I].DataType of
      ftString:
        Query1.Params[I].AsString := ListItem;
      ftSmallInt:
        Query1.Params[I].AsSmallInt := StrToIntDef(ListItem, 0);
      ftInteger:
        Query1.Params[I].AsInteger := StrToIntDef(ListItem, 0);
      ftWord:
        Query1.Params[I].AsWord := StrToIntDef(ListItem, 0);
      ftBoolean:
        begin
          if ListItem = 'True' then
            Query1.Params[I].AsBoolean := True
          else
            Query1.Params[I].AsBoolean := False;
        end;
      ftFloat:
        Query1.Params[I].AsFloat := StrToFloat(ListItem);
      ftCurrency:
        Query1.Params[I].AsCurrency := StrToFloat(ListItem);
      ftBCD:
        Query1.Params[I].AsBCD := StrToCurr(ListItem);
      ftDate:
        Query1.Params[I].AsDate := StrToDate(ListItem);
      ftTime:
        Query1.Params[I].AsTime := StrToTime(ListItem);
      ftDateTime:
        Query1.Params[I].AsDateTime := StrToDateTime(ListItem);
    end;
  end;
end; 
