unit FileExists;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// BeginExample: FileExists
// Routine: SysUtils.FileExists
// Routine: SysUtils.DeleteFile
// Routine: SysUtils.ExtractFilePath

// BeginCode
{
The following code prompts for confirmation before deleting
a file.  Create a file and then enter the path and file name
in the textfields.  Click the button to delete it.
}
procedure TForm1.Button1Click(Sender: TObject);
var FileName: string;
begin
  Filename:= Edit1.Text;
  if SysUtils.FileExists(FileName) then
  begin
    if MessageDlg(('Do you really want to delete ' + ExtractFileName(FileName) + '?'), mtConfirmation, [mbYes, mbNo], 0, mbNo) = IDYes then
      DeleteFile(FileName);
  end
  else
    MessageDlg(('File ' + ExtractFileName(FileName) + ' does not exist.'), mtConfirmation, [mbOK], 0);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Edit2.Text:= ExtractFilePath(Application.ExeName);
end;
// EndCode
// EndExample: FileExists
end.
